/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/service/IServiceTypesConst.java#3 $
 */

package com.sapportals.wcm.service;

/**
 * Defines known service type constants <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //kmgmt/bc.sf/dev/src/_framework/java/api/com/sapportals/wcm/service/IServiceTypesConst.java#4
 *      $
 */
public interface IServiceTypesConst {

  /**
   * identifier for URL Generator
   */
  public final static String URLGENERATOR_SERVICE = "URLGeneratorService";

  /**
   * identifier for AccessStatistic-Service
   */
  public final static String ACCESSSTATISTIC_SERVICE = "accessstatistic";

  /**
   * identifier for ListFilter-Service
   */
  public final static String LISTFILTER_SERVICE = "ResourceListFilterService";

  /**
   * identifier for Action Inbox
   */
  public final static String ACTION_INBOX_SERVICE = "ActionInboxService";

  /**
   * identifier for Application Log
   */
  public final static String APPLOG_SERVICE = "AppLogService";

  /**
   * identifier for FSMount
   */
  public final static String FSMOUNT_SERVICE = "FSMountService";

  /**
   * identifier for Cache
   */
  public final static String CACHE_SERVICE = "CacheService";

  /**
   * identifier for Crawler-Service
   */
  public final static String CRAWLER_SERVICE = "CrawlerService";

  /**
   * identifier for Index-Service
   */
  public final static String INDEX_SERVICE = "IndexmanagementService";

  /**
   * identifier for landscape service
   */
  public final static String LANDSCAPE_SERVICE = "LandscapeService";

  //** identifier for mime handler service */
  public final static String MIME_SERVICE = "MimeHandlerService";

  /**
   * identifier for global service Notificator
   */
  public final static String NOTIFICATOR_SERVICE = "NotificatorService";

  /**
   * identifier for object type handler service
   */
  public final static String OTH_SERVICE = "ObjectTypeHandlerService";

  /**
   * identifier for pipeline service
   */
  public final static String PIPELINE_SERVICE = "PipelineService";

  /**
   * identifier for XSLT pipeline service
   */
  public final static String XSLT_PIPELINE_SERVICE = "XSLTPipelineService";

  /**
   * identifier for URI Mapper
   */
  public final static String URIMAPPER_SERVICE = "UriMapperService";

  /**
   * identifier for Subscription-Service
   */
  public final static String SCHEDULER_SERVICE = "SchedulerService";

  /**
   * identifier for Ordered Link Service
   */
  public final static String ORDERED_LIST_SERVICE = "OrderedListService";

  /**
   * identifier for QuickPoll Service (QuickVote)
   */
  public final static String QUICKPOLL_SERVICE = "QuickPollService";

  /**
   * identifier for TaskQueue Service
   */
  public final static String TASKQUEUE_SERVICE = "TaskQueueService";

  /**
   * identifier for XML Forms Service
   */
  public final static String XMLFORMS_SERVICE = "XMLFormsService";

  /**
   * meta info service for property configuration
   */
  public final static String PROPERTY_CONFIG_SERVICE = "PropertyConfigurationService";

  /**
   * identifier for Checkout-Service
   */
  public final static String CHECKOUT_SERVICE = "CheckoutService";

  /**
   * identifier for Template-Service
   */
  public final static String TEMPLATE_SERVICE = "TemplateService";

  /**
   * identifier for Relation-Service
   */
  public final static String RELATION_SERVICE = "RelationService";

  /**
   * identifier for Reporting-Service
   */
  public final static String REPORTING_SERVICE = "ReportingService";

  /**
   * identifier for PropertyStructure-Service
   */
  public final static String PROPERTY_STRUCTURE_SERVICE = "PropertyStructureService";

  /**
   * identifier for XCrawler-Service
   */
  public final static String XCRAWLER_SERVICE = "XCrawlerService";

  /**
   * identifier for Resource Filter-Service
   */
  public final static String RESOURCE_FILTER_SERVICE = "ResourceFilterService";

  /**
   * identifier for Colaboration Service
   */
  public final static String COLLABORATION_SERVICE = "CollaborationService";

  /**
   * identifier for Virus Scan Service
   */
  public final static String VIRUSSCAN_SERVICE = "VirusScanService";
}
