/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/service/IServiceFactory.java#1 $
 */

package com.sapportals.wcm.service;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.factories.*;
import com.sapportals.wcm.util.log.*;

import java.util.*;

/**
 * An interface for a service factory (for repository independent services). <p>
 *
 *
 */
public interface IServiceFactory {

  /**
   * Returns a instance for a given service type identifier
   *
   * @param type The service type
   * @return A service instance
   * @exception WcmException Exception raised in failure situation
   */
  public IService getService(String type)
    throws WcmException;

  /**
   * Returns true if the service is available.
   *
   * @param type Checks if the service is available.
   * @return true if the service is available
   * @exception WcmException Exception raised in failure situation
   */
  public boolean isAvailable(String type)
    throws WcmException;

  /**
   * Returns all services
   *
   * @return A collection of IService instances
   * @exception WcmException Exception raised in failure situation
   */
  public Collection getAllServices()
    throws WcmException;

  /**
   * Releases the service instance.
   *
   * @param service The service instance to release.
   * @exception WcmException Exception raised in failure situation
   */
  public void releaseService(IService service)
    throws WcmException;
}
