/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/service/IService.java#2 $
 */

package com.sapportals.wcm.service;

import java.util.Locale;

/**
 * A "global" service is not attached to a repository in the configuration. It
 * can provide any kind of service for all CM compoments and might not deal with
 * resources at all. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id: //kmgmt/bc.sf/dev/src/_framework/java/api/com/sapportals/wcm/service/IService.java#4
 *      $
 */
public interface IService {

  /**
   * Get a service identifier, unique for this instance.
   *
   * @return The unique ID of this service.
   */
  public String getID();


  /**
   * Get a description for this service.
   *
   * @return The discription of the service.
   */
  public String getDescription();


  /**
   * Get a description for this service.
   *
   * @param locale TBD: Description of the incoming method parameter
   * @return The discription of the service.
   */
  public String getDescription(Locale locale);
}
