/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_runtime_repository_pmr/src/packages/com/sap/tc/webdynpro/progmodel/repository/enum/WDViewLifespanEnumInfo.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.repository.enum;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Enumeration for view lifecycle control values. 
 * @author SAP
 */
public class WDViewLifespanEnumInfo
{
  /**
   * A view instance is created like for {@link #WHEN_VISIBLE} and deleted on a
   * point in time decided by the Web Dynpro framework (but not before it would
   * be deleted in case of {@link #WHEN_VISIBLE}.
   */
  public static final WDViewLifespanEnumInfo FRAMEWORK_CONTROLLED = new WDViewLifespanEnumInfo("framework_controlled");
  
  /**
   * A view instance is created when it gets part of the view assembly and is
   * deleted, if it is no longer part of the view assembly. 
   */
  public static final WDViewLifespanEnumInfo WHEN_VISIBLE = new WDViewLifespanEnumInfo("when_visible");

  private static Hashtable mMemberTable = init();
  private String mStringValue = null;

  // WDViewLifespanEnumInfo()
  private WDViewLifespanEnumInfo(String value)
  {
    mStringValue = value;
  }

  /**
   * Returns an enumeration of the legal values of this enerumeration type.
   * @return an enumeration of the legal values of this enerumeration type
   */
  public static Enumeration enumerate()
  {
    return mMemberTable.elements();
  }

  // init()
  private static Hashtable init()
  {
    Hashtable members = new Hashtable();
    members.put("framework_controlled", FRAMEWORK_CONTROLLED);
    members.put("when_visible", WHEN_VISIBLE);
    return members;
  }

  /**
   * Returns the string representation for this enumeration value.
   * @return the string representation for this enumeration value.
   */
  public String toString()
  {
    return mStringValue;
  }

  /**
   * Returns the enumeration value corresponding to the given string
   * representation.
   * @param string string representation of an enumeration value
   * @return the enumeration value corrseponding to the given string 
   * representation or null if it does not exist
   */
  public static WDViewLifespanEnumInfo valueOf(String string)
  {
    Object obj = null;
    if (string != null) obj = mMemberTable.get(string);
    return (WDViewLifespanEnumInfo) obj;
  }
}
