/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: TransactionalEventBroker.java,v 1.1 2005/01/21 11:49:20 mbo Exp $
 */

package com.sapportals.wcm.util.events;


import com.sap.tc.logging.Location;
import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.WcmException;

import java.util.*;

/**
 * An event broker implementation <p>
 *      
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @see IEventBroker
 *
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/events/EventBroker.java#14
 *      $
 */
public class TransactionalEventBroker extends EventBroker implements ITransactionalEventBroker  {

  private static Location log = Location.getLocation(TransactionalEventBroker.class);

  // ----------------------------------- Interface -----------------------------

  
  public boolean send(IFrameworkTransaction ft, IEvent event, IEventSender sender)
    throws WcmException {    
    if (event != null) {
      /*
      if (!this.senderMap.containsKey(((Object)sender).toString())) {
        throw new WcmException("Event sender is not registered: " + ((Object)sender).toString());
      }
      */
      List rl = super.getReceiverEntries();
      for (int i = 0, n = rl.size(); i < n; ++i) {
        ReceiverEntry entry = (ReceiverEntry)rl.get(i);
        if( event.isLike(entry.getTemplate()) ) {
          if (entry.getState().equals(SenderMode.SENDING)) {
            if (ft.willBeRollbacked() || !entry.doSend(ft, event)) return false;
          }          
        }
      }
    }    
    return true;
  }
  
 }
