/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;
import com.sap.tc.logging.Location;
import com.sapportals.wcm.util.logging.LoggingFormatter;

/**
 * This event receiver encapsulates the receiver object, the queue and a sender thread for
 * asynchronous events.
 */
public class Receiver {

  private static Location log = Location.getLocation(Receiver.class);

  private final static int QUEUE_MAX_SIZE = 10000;

  /**
   * Queue for async. reveivers
   */
  private EventQueue queue;

  /**
   * The single event sender thread per receiver.
   */
  private EventSenderThread thread;

  private IEventReceiver rec;

  Receiver (IEventReceiver rec) {
    this.rec = rec;
  }

	void setAsync() {
		// Init. queue and thread when called for the first time
		if (this.queue == null) {
			this.queue = new EventQueue(Receiver.QUEUE_MAX_SIZE);
			this.thread = new EventSenderThread(this.queue, this.rec);
		}
	}

  /**
   * Returns the event receiver instance.
   */
  IEventReceiver getReceiver() {
    return this.rec;
  }

  /**
   * Returns the queue object. Null if the receiver has not registered for
   * async. events (yet).
   */
  EventQueue getQueue() {
	  return this.queue;
  }
  
	void terminateThread() {
		if (this.thread != null) {
      while ( this.thread.isAlive()) {
  			this.thread.terminate();
        try {
          this.thread.join() ;
        }
        catch ( InterruptedException ie ) {
          if ( log.beDebug()) {
            log.debugT ( "KM RF event receiver thread interrupted while waiting "
              + "for async thread to terminate" ) ;
          }
        }
      }
      this.thread = null;
		}
	}
	
	public boolean equals(Object other) {
		// Use object identity of receiver object
		if (other instanceof Receiver) {
			return (this.rec == ((Receiver)other).rec);
		}
		else {
			return false;
		}		
	}
}
