/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import com.sap.tc.logging.Location;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import java.util.*;

/**
 * Consumes events from the queue an calls the receivers received() method.
 */
public class EventSenderThread extends Thread {

  private static Location log = Location.getLocation(EventSenderThread.class);

  private boolean stop;
  private EventQueue queue;
  private IEventReceiver receiver;

  EventSenderThread(EventQueue queue, IEventReceiver receiver) {
    this.queue = queue;
    this.receiver = receiver;
    this.setName("KM RF event sender thread for receiver: " + receiver);
    this.start();
  }

  /**
   * Do the work
   */
  public void run() {
    long start = 0L;
    while (!terminated()) {
      IEvent event = this.queue.dequeue();
      if (event != null) {
        try {
          this.receiver.received(event);
        }
        catch (Throwable t) {
          log.errorT("run(62)", "Runtime Exception in event receiver" + " - " + LoggingFormatter.extractCallstack(t));
        }
      }
    }
    log.debugT("run(65)", "Terminated");
  }

  /**
   * Will cause the thread to stop (if it is not waiting on a empty queue)
   */
  void terminate() {
    this.stop = true;
    interrupt();
    log.debugT("terminate(74)", "terminate() was called");
  }

  private boolean terminated() {
    return this.stop;
  }
}
