/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.support;

import java.util.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class SupportedOptionTransformer {
  private final static Object[][] mappingTable = new Object[][]{
    {com.sapportals.wcm.repository.enum.SupportedOption.GET_CONTENT, com.sap.netweaver.bc.rf.common.content.SupportedOption.GET_CONTENT},
    {com.sapportals.wcm.repository.enum.SupportedOption.UPDATE_CONTENT, com.sap.netweaver.bc.rf.common.content.SupportedOption.UPDATE_CONTENT},
    {com.sapportals.wcm.repository.enum.SupportedOption.CREATE_RESOURCE, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.CREATE_RESOURCE},
    {com.sapportals.wcm.repository.enum.SupportedOption.DELETE, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.DELETE},
    {com.sapportals.wcm.repository.enum.SupportedOption.DELETE_DEEP, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.DELETE_DEEP},
    {com.sapportals.wcm.repository.enum.SupportedOption.GET_PROPERTIES, com.sap.netweaver.bc.rf.common.property.SupportedOption.GET_PROPERTIES},
    {com.sapportals.wcm.repository.enum.SupportedOption.SET_PROPERTIES, com.sap.netweaver.bc.rf.common.property.SupportedOption.SET_PROPERTIES},
    {com.sapportals.wcm.repository.enum.SupportedOption.RENAME, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.RENAME},
    {com.sapportals.wcm.repository.enum.SupportedOption.LINKING, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.LINKING},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_READ, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_READ},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_WRITE, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_WRITE},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_SHARED, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_SHARED},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_EXCLUSIVE, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_EXCLUSIVE},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_DEEP, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_DEEP},
    {com.sapportals.wcm.repository.enum.SupportedOption.LOCKING_SHALLOW, com.sap.netweaver.bc.rf.common.lock.SupportedOption.LOCK_SHALLOW},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSIONING, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSIONING},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSIONED_COLLECTIONS, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSIONED_COLLECTIONS},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSIONED_PROPERTIES, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSIONED_PROPERTIES},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSIONED_LINKS, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSIONED_LINKS},
    {com.sapportals.wcm.repository.enum.SupportedOption.EXPECTED_VERSION_URI, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.ORDERED_COLLECTIONS, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.ORDERED_COLLECTIONS},
    {com.sapportals.wcm.repository.enum.SupportedOption.INTERNAL_COPY, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.COPY},
    {com.sapportals.wcm.repository.enum.SupportedOption.INTERNAL_COPY_DEEP, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.COPY_DEEP},
    {com.sapportals.wcm.repository.enum.SupportedOption.INTERNAL_MOVE, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.MOVE},
    {com.sapportals.wcm.repository.enum.SupportedOption.PROPERTY_ATTRIBUTES, com.sap.netweaver.bc.rf.common.property.SupportedOption.PROPERTY_ATTRIBUTES},
    {com.sapportals.wcm.repository.enum.SupportedOption.PROPERTY_MULTIVALUED, com.sap.netweaver.bc.rf.common.property.SupportedOption.PROPERTY_MULTIVALUED},
    {com.sapportals.wcm.repository.enum.SupportedOption.CREATE_COLLECTION, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.CREATE_COLLECTION},
    {com.sapportals.wcm.repository.enum.SupportedOption.RESOLVES_LINKS, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.RESOLVES_LINKS},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSION_HISTORY_RESOURCES, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_HISTORY_RESOURCES},
    {com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING_CHECKOUT_CHECKIN, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING_CHECKOUT_UNLOCKED_CHECKIN, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING_CHECKOUT, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING_LOCKED_CHECKOUT, null}, // Deprecated
  {com.sapportals.wcm.repository.enum.SupportedOption.VERSION_LABELS, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_LABELS},
    {com.sapportals.wcm.repository.enum.SupportedOption.WORKING_RESOURCE, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_WORKING_RESOURCE},
    {com.sapportals.wcm.repository.enum.SupportedOption.UPDATE_FROM_VERSION, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_UPDATE_FROM},
    {com.sapportals.wcm.repository.enum.SupportedOption.INTERNAL_DYNAMIC_LINKS, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.INTERNAL_DYNAMIC_LINKS},
    {com.sapportals.wcm.repository.enum.SupportedOption.WORKSPACES, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_WORKSPACES},
    {com.sapportals.wcm.repository.enum.SupportedOption.VERSION_CONTROL, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_CONTROL},
    {com.sapportals.wcm.repository.enum.SupportedOption.CREATE_WORKSPACE, com.sap.netweaver.bc.rf.common.version.SupportedOption.VERSION_CREATE_WORKSPACE},
    {com.sapportals.wcm.repository.enum.SupportedOption.NONHIERARCHICAL_NAMESPACE, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.NON_HIERARCHICAL_NAMESPACE},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_RESOURCES_COLLECTION},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_RESOURCES_ITERATOR},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_RESOURCES_COLLECTION_OFFSET_LENGTH},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_RESOURCES_COLLECTION_RESULTSTATE},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_RESOURCES_ITERATOR_STARTINDEX_FETCHSIZE},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_BASIC_CHILDREN_RESOURCES},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_ADVANCED_CHILDREN_RESOURCES},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_ADVANCED_DEEP_RESOURCES},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FIND_ADVANCED_DEEP_VERSIONED_RESOURCES},
    {null, com.sap.netweaver.bc.rf.common.namespace.SupportedOption.COUNT_RESOURCES}};

  private static HashMap supportedOptionsMappedByOldSupportedOption = new HashMap();
  private static HashMap supportedOptionsMappedByNewSupportedOption = new HashMap();

  static {
    for (int i = 0; i < mappingTable.length; i++) {
      if (mappingTable[i][0] != null) {
        supportedOptionsMappedByOldSupportedOption.put(mappingTable[i][0], mappingTable[i][1]);
      }
      if (mappingTable[i][1] != null) {
        supportedOptionsMappedByNewSupportedOption.put(mappingTable[i][1], mappingTable[i][0]);
      }
    }
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgSupportedOption TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static com.sapportals.wcm.repository.enum.SupportedOption transform(com.sap.netweaver.bc.rf.common.support.SupportedOption orgSupportedOption) {
    com.sapportals.wcm.repository.enum.SupportedOption supportedOption = null;
    if (orgSupportedOption != null) {
      supportedOption = (com.sapportals.wcm.repository.enum.SupportedOption)supportedOptionsMappedByNewSupportedOption.get(orgSupportedOption);
    }
    return supportedOption;
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgSupportedOption TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static com.sap.netweaver.bc.rf.common.support.SupportedOption transform(com.sapportals.wcm.repository.enum.SupportedOption orgSupportedOption) {
    com.sap.netweaver.bc.rf.common.support.SupportedOption supportedOption = null;
    if (orgSupportedOption != null) {
      supportedOption = (com.sap.netweaver.bc.rf.common.support.SupportedOption)supportedOptionsMappedByOldSupportedOption.get(orgSupportedOption);
    }
    return supportedOption;
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgSet TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static Set transform(Set orgSet) {
    Set result = new HashSet();
    for (Iterator iter = orgSet.iterator(); iter.hasNext(); ) {
      Object supportedOption = iter.next();
      Object transformedOption = null;
      if (supportedOption instanceof com.sapportals.wcm.repository.enum.SupportedOption) {
        transformedOption = transform((com.sapportals.wcm.repository.enum.SupportedOption)supportedOption);
      }
      if (supportedOption instanceof com.sap.netweaver.bc.rf.common.support.SupportedOption) {
        transformedOption = transform((com.sap.netweaver.bc.rf.common.support.SupportedOption)supportedOption);
      }
      if (transformedOption != null) {
        result.add(transformedOption);
      }
    }
    return result;
  }

//    public static void main(String[] args)
//    {
//        Set set = new HashSet();
//        set.add(com.sapportals.wcm.repository.enum.SupportedOption.GET_CONTENT);
//        set.add(com.sapportals.wcm.repository.enum.SupportedOption.AUTOVERSIONING);
//        set = transform ( set );
//        for (Iterator iter = set.iterator(); iter.hasNext();)
//        {
//            System.out.println(iter.next());
//        }
//        set.clear();
//        set.add(com.sap.netweaver.bc.rf.common.content.SupportedOption.GET_CONTENT);
//        set.add(com.sap.netweaver.bc.rf.common.namespace.SupportedOption.FILTER);
//        set = transform ( set );
//        for (Iterator iter = set.iterator(); iter.hasNext();)
//        {
//            System.out.println(iter.next());
//        }
//    }
}
