/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security.acl;
import com.sap.netweaver.bc.rf.common.IResourceHandle;
import com.sapportals.portal.security.usermanagement.IUMPrincipal;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.repository.runtime.CmSystem;
import com.sapportals.wcm.repository.security.*;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.security.*;
import com.sapportals.wcm.repository.wrapping.security.acl.*;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * Wraps a new ACL with the old interface.
 */
public class AclWrapper implements IResourceAcl {

  private final IResource res;
  private final com.sap.netweaver.bc.rf.common.security.acl.IAcl acl;

  protected AclWrapper(com.sap.netweaver.bc.rf.common.security.acl.IAcl acl, IResource res) {
    this.acl = acl;
    this.res = res;
  }

  protected com.sap.netweaver.bc.rf.common.security.acl.IAcl getNewAcl() {
    return this.acl;
  }


  public boolean addOwner(IUMPrincipal owner)
    throws AclPersistenceException, NotAuthorizedException, ResourceException {
    try {
      this.acl.addOwner(PrincipalTransformer.transform(owner));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public boolean removeOwner(IUMPrincipal owner)
    throws AclPersistenceException, NotAuthorizedException, LastOwnerException, ResourceException {
    try {
      this.acl.removeOwner(PrincipalTransformer.transform(owner));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw new NotAuthorizedException();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclLastOwnerException ex) {
      throw new LastOwnerException();
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public boolean isOwner(IUMPrincipal principal)
    throws AclPersistenceException {
    try {
      return this.acl.isOwner(PrincipalTransformer.transform(principal));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean isAuthorized(IUMPrincipal principal)
    throws AclPersistenceException {
    try {
      return this.acl.isAuthorized(PrincipalTransformer.transform(principal));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public IUMPrincipalList getOwners()
    throws AclPersistenceException {
    try {
      List l = this.acl.getOwners();
      UMPrincipalList result = new UMPrincipalList();
      for (int i = 0, s = l.size(); i < s; i++) {
        result.add((IUMPrincipal)l.get(i));
      }
      return result;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public boolean addEntry(IResourceAclEntry aclEntry)
    throws AclPersistenceException, InvalidClassException, NotAuthorizedException, AlreadyAssignedToAclException, PermissionNotSupportedException, ResourceException {
    try {
      return this.acl.addEntry(AclEntryTransformer.transform(aclEntry));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw new NotAuthorizedException();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclAlreadyAssignedToAclException ex) {
      throw new AlreadyAssignedToAclException();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPermissionNotSupportedException ex) {
      throw new PermissionNotSupportedException();
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean removeEntry(IResourceAclEntry aclEntry)
    throws AclPersistenceException, InvalidClassException, NotAuthorizedException, ResourceException {
    try {
      return this.acl.removeEntry(AclEntryTransformer.transform(aclEntry));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw new NotAuthorizedException();
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public IResourceAclEntryList getEntries()
    throws AclPersistenceException {
    try {
      return AclEntryTransformer.transformList(this.acl.getEntries());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }


  public IResourceAclEntryList getEntries(IUMPrincipal principal)
    throws AclPersistenceException {
    try {
      return AclEntryTransformer.transformList(this.acl.getEntries());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean checkPermission(IUMPrincipal principal, IAclPermission permission)
    throws AclPersistenceException {
    try {
      return this.acl.checkPermission(PrincipalTransformer.transform(principal), AclPermissionTransformer.transform(permission));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean isReadOnly()
    throws AclPersistenceException {
    try {
      return this.acl.isReadOnly();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public IResource getResource()
    throws AclPersistenceException {
    return this.res;
  }

  public boolean lock()
    throws AclPersistenceException, NotAuthorizedException {
    throw new UnsupportedOperationException();
  }

  public boolean isLocked()
    throws AclPersistenceException {
    try {
      return this.acl.isLocked();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public IUMPrincipal getLockingUser()
    throws AclPersistenceException {
    try {
      return PrincipalTransformer.transform(this.acl.getLockingUser());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public void unlock()
    throws AclPersistenceException, NotAuthorizedException {
    throw new UnsupportedOperationException();
  }

  public boolean isUpToDate()
    throws AclPersistenceException {
    throw new UnsupportedOperationException();
  }

}
