/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security.acl;
import com.sapportals.portal.security.usermanagement.IUMPrincipal;
import com.sapportals.portal.security.usermanagement.UMFactory;
import com.sapportals.wcm.repository.runtime.ResourceAclAdapter;
import com.sapportals.wcm.repository.security.*;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.security.PrincipalTransformer;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * Wraps a new ACL entry with the old interface.
 */
public class AclEntryWrapper implements IResourceAclEntry {

  private final com.sap.netweaver.bc.rf.common.security.acl.IAclEntry entry;

  protected AclEntryWrapper(com.sap.netweaver.bc.rf.common.security.acl.IAclEntry entry) {
    this.entry = entry;
  }

  protected com.sap.netweaver.bc.rf.common.security.acl.IAclEntry getNewAclEntry() {
    return this.entry;
  }

  public IAclPermission getPermission()
    throws AclPersistenceException {
    try {
      return AclPermissionTransformer.transform(this.entry.getPermission());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean checkPermission(IAclPermission permission)
    throws AclPersistenceException, InvalidClassException {
    try {
      return this.entry.checkPermission(AclPermissionTransformer.transform(permission));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean isNegative()
    throws AclPersistenceException {
    try {
      return this.entry.isNegative();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public IUMPrincipal getPrincipal()
    throws AclPersistenceException {
    try {
      return PrincipalTransformer.transform(this.entry.getPrincipal());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public boolean isReadOnly()
    throws AclPersistenceException {
    try {
      return this.entry.isReadOnly();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public int getSortIndex()
    throws AclPersistenceException {
    try {
      return this.entry.getSortIndex();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
  }

  public void setSortIndex(int sortIndex)
    throws AclPersistenceException, NotAuthorizedException {
    try {
      this.entry.setSortIndex(sortIndex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw new AclPersistenceException(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw new NotAuthorizedException();
    }
  }
}
