/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security;
import com.sapportals.portal.security.usermanagement.IGroup;
import com.sapportals.portal.security.usermanagement.IRole;

import com.sapportals.portal.security.usermanagement.IUMPrincipal;
import com.sapportals.portal.security.usermanagement.IUser;
import com.sapportals.portal.security.usermanagement.UMFactory;

/**
 * Transforms usermanagement principals.
 */
public final class PrincipalTransformer {

  public static IUMPrincipal transform(com.sap.security.api.IPrincipal p) {
    try {
      String id = p.getUniqueID();
      if (p instanceof com.sap.security.api.IUser) {
        return UMFactory.getInstance().getDefaultFactory().getEP5User((com.sap.security.api.IUser)p);
      }
      else if (p instanceof com.sap.security.api.IGroup) {
        return UMFactory.getInstance().getGroupFactory().getEP5Group((com.sap.security.api.IGroup)p);
      }
      else if (p instanceof com.sap.security.api.IRole) {
        return UMFactory.getInstance().getRoleFactory().getEP5Role((com.sap.security.api.IRole)p);
      }
      else {
        throw new ClassCastException("unknown principal type");
      }
    }
    catch (Exception ex) {
      throw new RuntimeException("Failed to transform usermanagement principal: " + ex.getMessage());
    }
  }

  public static com.sap.security.api.IPrincipal transform(IUMPrincipal p) {
    if (p instanceof IUser) {
      return ((IUser)p).getUMEUser();
    }
    else if (p instanceof IGroup) {
      return ((IGroup)p).getUMEGroup();
    }
    else if (p instanceof IRole) {
      return ((IRole)p).getUMERole();
    }
    else {
      throw new RuntimeException("unexpected IPrincipal type: " + p.getClass().getName());
    }
  }

}
