/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security;

import com.sap.netweaver.bc.rf.common.security.IPermission;
import com.sap.netweaver.bc.rf.common.security.Permission;
import java.util.HashMap;
import java.util.Map;

/**
 * Transforms permission objects.
 */
public final class PermissionTransformer {

  /*
   * reverseMap maps known new permissions back to old ones
   * forwardMap maps known old permissions to new ones
   */
  private final static Map forwardMap, reverseMap;

  static {
    forwardMap = new HashMap();
    forwardMap.put(
      Permission.PERMISSION_READ_CONTENT.getName(),
      com.sapportals.wcm.repository.manager.Permission.READ_CONTENT);
    forwardMap.put(
      Permission.PERMISSION_READ_PROPERTIES.getName(),
      com.sapportals.wcm.repository.manager.Permission.READ_PROPERTIES);
    forwardMap.put(
      Permission.PERMISSION_WRITE_CONTENT.getName(),
      com.sapportals.wcm.repository.manager.Permission.WRITE_CONTENT);
    forwardMap.put(
      Permission.PERMISSION_WRITE_PROPERTIES.getName(),
      com.sapportals.wcm.repository.manager.Permission.WRITE_PROPERTIES);
    forwardMap.put(
      Permission.PERMISSION_DELETE.getName(),
      com.sapportals.wcm.repository.manager.Permission.DELETE);
    forwardMap.put(
      Permission.PERMISSION_LIST.getName(),
      com.sapportals.wcm.repository.manager.Permission.LIST);
    forwardMap.put(
      Permission.PERMISSION_CREATE.getName(),
      com.sapportals.wcm.repository.manager.Permission.CREATE);
    forwardMap.put(
      Permission.PERMISSION_READ_NODE_PROPERTIES.getName(),
      com.sapportals.wcm.repository.manager.Permission.READ_NODE_PROPERTIES);
    forwardMap.put(
      Permission.PERMISSION_WRITE_NODE_PROPERTIES.getName(),
      com.sapportals.wcm.repository.manager.Permission.WRITE_NODE_PROPERTIES);
    forwardMap.put(
      Permission.PERMISSION_DELETE_NODE.getName(),
      com.sapportals.wcm.repository.manager.Permission.DELETE_NODE);

    reverseMap = new HashMap();
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.READ_CONTENT.getName(),
      Permission.PERMISSION_READ_CONTENT);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.READ_PROPERTIES.getName(),
      Permission.PERMISSION_READ_PROPERTIES);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.WRITE_CONTENT.getName(),
      Permission.PERMISSION_WRITE_CONTENT);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.WRITE_PROPERTIES.getName(),
      Permission.PERMISSION_WRITE_PROPERTIES);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.DELETE.getName(),
      Permission.PERMISSION_DELETE);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.LIST.getName(),
      Permission.PERMISSION_LIST);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.CREATE.getName(),
      Permission.PERMISSION_CREATE);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.READ_NODE_PROPERTIES.getName(),
      Permission.PERMISSION_READ_NODE_PROPERTIES);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.WRITE_NODE_PROPERTIES.getName(),
      Permission.PERMISSION_WRITE_NODE_PROPERTIES);
    reverseMap.put(
      com.sapportals.wcm.repository.manager.Permission.DELETE_NODE.getName(),
      Permission.PERMISSION_DELETE_NODE);
  }

  /*
   * return null for unknown permissions as they cannot be dealt
   * with in the old world
   */
  public static com.sapportals.wcm.repository.manager.IPermission transform(IPermission perm) {
    if (perm == null) return null;    
    return (com.sapportals.wcm.repository.manager.IPermission)forwardMap.get(perm.getName());
  }

  public static IPermission transform(com.sapportals.wcm.repository.manager.IPermission perm) {
    if (perm == null) return null;
    return (IPermission)reverseMap.get(perm.getName());
  }
}
