/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security;

import com.sap.netweaver.bc.rf.common.security.IPermission;
import java.util.ArrayList;
import java.util.Iterator;

import java.util.List;

/**
 * Transforms permission list objects.
 */
public final class PermissionListTransformer {

  public static com.sapportals.wcm.repository.manager.IPermissionList transform(List l) {
    if (l == null) return null;
    com.sapportals.wcm.repository.manager.PermissionList list =
      new com.sapportals.wcm.repository.manager.PermissionList();
    Iterator it = l.iterator();
    while (it.hasNext()) {
      list.add(PermissionTransformer.transform((IPermission)it.next()));
    }
    return list;  
  }


  public static List transform(com.sapportals.wcm.repository.manager.IPermissionList l) {
    if (l == null) return null;
    List list = new ArrayList(l.size());
    com.sapportals.wcm.repository.manager.IPermissionListIterator it = l.iterator();
    while (it.hasNext()) {
      list.add(PermissionTransformer.transform(it.next()));
    }
    return list;  
  }
}
