/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.security;

import com.sapportals.wcm.util.acl.IObjectType;
import com.sapportals.wcm.util.acl.IObjectTypeList;
import com.sapportals.wcm.util.acl.ObjectTypeList;
import java.util.*;

/**
 * TBD: Description of the class.
 */
public final class ObjectTypeTransformer {

  public static IObjectType transform(com.sap.netweaver.bc.rf.mi.security.acl.IObjectType ot) {
    return new ObjectTypeWrapper(ot);
  }

  public static com.sap.netweaver.bc.rf.mi.security.acl.IObjectType transform(IObjectType ot) {
    return ((ObjectTypeWrapper)ot).getNewObjectType();
  }

  public static IObjectTypeList transformList(List l) {
    ObjectTypeList result = new ObjectTypeList();
    for (int i = 0, s = l.size(); i < s; i++) {
      result.add(ObjectTypeTransformer.transform((com.sap.netweaver.bc.rf.mi.security.acl.IObjectType)l.get(i)));
    }
    return result;
  }
}
