/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.namespace;

import com.sapportals.wcm.repository.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class QueryExpressionWrapperOut implements IQueryExpression {
  private final com.sap.netweaver.bc.rf.common.namespace.IQueryExpression orgQueryExpression;

  /**
   * Construct object of class QueryExpressionWrapperOut.
   *
   * @param orgQueryExpression TBD: Description of the incoming method parameter
   */
  public QueryExpressionWrapperOut(com.sap.netweaver.bc.rf.common.namespace.IQueryExpression orgQueryExpression) {
    this.orgQueryExpression = orgQueryExpression;
  }

  /**
   * Create a new AND expression which concatenates this expression with other
   * (this and other).
   *
   * @param other
   * @return new expression, representing condition (this and other)
   */
  public IQueryExpression and(IQueryExpression other) {
    return new QueryExpressionWrapperOut(orgQueryExpression.and(new QueryExpressionWrapperIn(other)));
  }

  /**
   * Create a new OR expression which concatenates this expression with other
   * (this or other).
   *
   * @param other
   * @return new expression, representing condition (this or other)
   */
  public IQueryExpression or(IQueryExpression other) {
    return new QueryExpressionWrapperOut(orgQueryExpression.or(new QueryExpressionWrapperIn(other)));
  }

  /**
   * Create a new NOT expression which negates this expression.
   *
   * @return new expression, representing condition (not this)
   */
  public IQueryExpression not() {
    return new QueryExpressionWrapperOut(orgQueryExpression.not());
  }
}
