/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.namespace;

import com.sapportals.wcm.repository.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class QueryBuilderWrapperOut implements IQueryBuilder {
  private final com.sap.netweaver.bc.rf.common.namespace.IQueryBuilder orgQueryBuilder;

  /**
   * Construct object of class QueryBuilderWrapperOut.
   *
   * @param orgQueryBuilder TBD: Description of the incoming method parameter
   */
  public QueryBuilderWrapperOut(com.sap.netweaver.bc.rf.common.namespace.IQueryBuilder orgQueryBuilder) {
    this.orgQueryBuilder = orgQueryBuilder;
  }

  /**
   * Returns a new expression which tests property == value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eq(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.eq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property == value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eq(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.eq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property == value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eqIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.eqIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }


  /**
   * Returns a new expression which tests property != value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEq(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.notEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property != value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEq(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.notEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property != value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEqIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.notEqIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression less(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.less(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression less(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.less(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value, ignoring case.
   *
   * @param name the name3 of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression lessIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.lessIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEq(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.lessEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEq(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.lessEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEqIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.lessEqIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greater(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greater(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greater(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greater(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greaterIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greaterIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEq(IPropertyName name, Object value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greaterEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEq(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greaterEq(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEqIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.greaterEqIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which is the complement of the given expression.
   *
   * @param expression to return complement of
   * @return expression representing !expression
   */
  public IQueryExpression not(IQueryExpression expression) {
    return new QueryExpressionWrapperOut(orgQueryBuilder.not(new QueryExpressionWrapperIn(expression)));
  }

  /**
   * Returns a new expression which tests property is like value, where value is
   * a wildcard expression. Wildcard characters are "_" and "%", where "_"
   * matches one character and "%" matches 0 or more characters. "\" can be used
   * as escape character and is only allowed to escape itself, "_" and "%".
   *
   * @param name the name of the property
   * @param value the wildcard expression
   * @return expression representing property like value
   */
  public IQueryExpression like(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.like(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property is like value, where value is
   * a wildcard expression. Wildcard characters are "_" and "%", where "_"
   * matches one character and "%" matches 0 or more characters. "\" can be used
   * as escape character and is only allowed to escape itself, "_" and "%".
   *
   * @param name the name of the property
   * @param value the wildcard expression
   * @return expression representing property like value
   */
  public IQueryExpression likeIgnoreCase(IPropertyName name, String value) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.likeIgnoreCase(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests for the properties existence.
   *
   * @param name the name of the property
   * @return expression representing "if exists property"
   */
  public IQueryExpression isDefined(IPropertyName name) {
    try {
      return new QueryExpressionWrapperOut(orgQueryBuilder.isDefined(com.sap.netweaver.bc.rf.util.namespace.Name.getName(name.getNamespace(), name.getName())));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests if the resource is a collection
   *
   * @return expression representing test if resource is collection
   */
  public IQueryExpression isCollection() {
    return new QueryExpressionWrapperOut(orgQueryBuilder.isCollection());
  }

  /**
   * @return constant false
   */
  public IQueryExpression constFalse() {
    return new QueryExpressionWrapperOut(orgQueryBuilder.constFalse());
  }

  /**
   * @return constant true
   */
  public IQueryExpression constTrue() {
    return new QueryExpressionWrapperOut(orgQueryBuilder.constTrue());
  }
}
