/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.namespace;

import com.sap.netweaver.bc.rf.common.namespace.*;
import com.sap.netweaver.bc.rf.util.namespace.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class QueryBuilderWrapperIn implements IQueryBuilder {
  private final com.sapportals.wcm.repository.IQueryBuilder orgQueryBuilder;

  /**
   * Construct object of class QueryBuilderWrapperIn.
   *
   * @param orgQueryBuilder TBD: Description of the incoming method parameter
   */
  public QueryBuilderWrapperIn(com.sapportals.wcm.repository.IQueryBuilder orgQueryBuilder) {
    this.orgQueryBuilder = orgQueryBuilder;
  }

  /**
   * Returns a new expression which tests property == value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eq(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.eq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property == value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eq(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.eq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property == value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property == value
   */
  public IQueryExpression eqIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.eqIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }


  /**
   * Returns a new expression which tests property != value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEq(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.notEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property != value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEq(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.notEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property != value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property != value
   */
  public IQueryExpression notEqIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.notEqIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression less(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.less(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression less(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.less(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property < value, ignoring case.
   *
   * @param name the name3 of the property
   * @param value to compare against
   * @return expression representing property < value
   */
  public IQueryExpression lessIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.lessIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEq(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.lessEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEq(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.lessEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property <= value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property <= value
   */
  public IQueryExpression lessEqIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.lessEqIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greater(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greater(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greater(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greater(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property > value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property > value
   */
  public IQueryExpression greaterIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greaterIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEq(IName name, Object value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greaterEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEq(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greaterEq(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property >= value, ignoring case.
   *
   * @param name the name of the property
   * @param value to compare against
   * @return expression representing property >= value
   */
  public IQueryExpression greaterEqIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.greaterEqIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which is the complement of the given expression.
   *
   * @param expression to return complement of
   * @return expression representing !expression
   */
  public IQueryExpression not(IQueryExpression expression) {
    return new QueryExpressionWrapperIn(orgQueryBuilder.not(new QueryExpressionWrapperOut(expression)));
  }

  /**
   * Returns a new expression which tests property is like value, where value is
   * a wildcard expression. Wildcard characters are "_" and "%", where "_"
   * matches one character and "%" matches 0 or more characters. "\" can be used
   * as escape character and is only allowed to escape itself, "_" and "%".
   *
   * @param name the name of the property
   * @param value the wildcard expression
   * @return expression representing property like value
   */
  public IQueryExpression like(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.like(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests property is like value, where value is
   * a wildcard expression. Wildcard characters are "_" and "%", where "_"
   * matches one character and "%" matches 0 or more characters. "\" can be used
   * as escape character and is only allowed to escape itself, "_" and "%".
   *
   * @param name the name of the property
   * @param value the wildcard expression
   * @return expression representing property like value
   */
  public IQueryExpression likeIgnoreCase(IName name, String value) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.likeIgnoreCase(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName()), value));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests for the properties existence.
   *
   * @param name the name of the property
   * @return expression representing "if exists property"
   */
  public IQueryExpression isDefined(IName name) {
    try {
      return new QueryExpressionWrapperIn(orgQueryBuilder.isDefined(new com.sapportals.wcm.repository.PropertyName(name.getNamespace(), name.getLocalName())));
    }
    catch (Exception exception) {
      return null;
    }
  }

  /**
   * Returns a new expression which tests if the resource is a collection
   *
   * @return expression representing test if resource is collection
   */
  public IQueryExpression isCollection() {
    return new QueryExpressionWrapperIn(orgQueryBuilder.isCollection());
  }

  /**
   * @return constant false
   */
  public IQueryExpression constFalse() {
    return new QueryExpressionWrapperIn(orgQueryBuilder.constFalse());
  }

  /**
   * @return constant true
   */
  public IQueryExpression constTrue() {
    return new QueryExpressionWrapperIn(orgQueryBuilder.constTrue());
  }
}
