/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.namespace;
import com.sap.netweaver.bc.rf.common.namespace.*;

import com.sapportals.wcm.repository.*;

import java.util.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class OrderPositionTransformer {
  /**
   * TBD: Description of the Method.
   *
   * @param orgReorderList TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static List transform(IReorderList orgReorderList) {
    java.util.List resultReorderList = new java.util.ArrayList();
    if (orgReorderList != null) {
      for (int i = 0; i < orgReorderList.size(); i++) {
        resultReorderList.add(
          transform((IPositioning)orgReorderList.get(i)));
      }
    }
    return resultReorderList;
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgPositioning TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static OrderPosition transform(IPositioning orgPositioning) {
    if (orgPositioning != null) {
      if (orgPositioning.getPosition()
        .getPosition()
        .equals(com.sapportals.wcm.repository.enum.OrderPosition.FIRST)) {
        return OrderPosition.createFirstPosition(
          orgPositioning.getResourceName());
      }
      else
        if (orgPositioning.getPosition()
        .getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.LAST)) {
        return OrderPosition.createLastPosition(
          orgPositioning.getResourceName());
      }
      else
        if (orgPositioning.getPosition()
        .getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.BEFORE)) {
        return OrderPosition.createBeforePosition(
          orgPositioning.getResourceName(),
          orgPositioning.getPosition().getRelativeName());
      }
      else
        if (orgPositioning.getPosition()
        .getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.AFTER)) {
        return OrderPosition.createAfterPosition(
          orgPositioning.getResourceName(),
          orgPositioning.getPosition().getRelativeName());
      }
    }
    return null;
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgPosition TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static OrderPosition transform(IPosition orgPosition) {
    if (orgPosition != null) {
      if (orgPosition.getPosition()
        .equals(com.sapportals.wcm.repository.enum.OrderPosition.FIRST)) {
        return OrderPosition.createFirstPosition(null);
      }
      else
        if (orgPosition.getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.LAST)) {
        return OrderPosition.createLastPosition(null);
      }
      else
        if (orgPosition.getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.BEFORE)) {
        return OrderPosition.createBeforePosition(
          null,
          orgPosition.getRelativeName());
      }
      else
        if (orgPosition.getPosition()
        .equals(
        com.sapportals.wcm.repository.enum.OrderPosition.AFTER)) {
        return OrderPosition.createAfterPosition(
          null,
          orgPosition.getRelativeName());
      }
    }
    return null;
  }
}
