/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.lock;
import com.sapportals.wcm.repository.ILockInfoCollection;
import com.sapportals.wcm.repository.LockInfoCollection;

import com.sapportals.wcm.repository.wrapping.*;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class LockInfoTransformer {
  /**
   * TBD: Description of the Method.
   *
   * @param orgLockInfo TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception com.sap.netweaver.bc.rf.common.exception.ResourceException
   *      Exception raised in failure situation
   */
  public static com.sap.netweaver.bc.rf.common.lock.ILockInfo transform(com.sapportals.wcm.repository.ILockInfo orgLockInfo)
    throws com.sap.netweaver.bc.rf.common.exception.ResourceException {
    if (orgLockInfo == null) {
      return null;
    }
    return new com.sap.netweaver.bc.rf.mi.lock.LockInfo(orgLockInfo.getLockToken(), null, LockDepthTypeTransformer.transform(orgLockInfo.getDepth()), LockScopeTypeTransformer.transform(orgLockInfo.getScope()), LockKindTypeTransformer.transform(orgLockInfo.getType()), orgLockInfo.getCreated(), orgLockInfo.getTimeout() * 1000L, orgLockInfo.getOwner(), orgLockInfo.getClientSuppliedOwner().toString());
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgLockInfo TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception com.sap.netweaver.bc.rf.common.exception.ResourceException
   *      Exception raised in failure situation
   */
  public static com.sap.netweaver.bc.rf.common.lock.ILockInfo transform(com.sapportals.wcm.repository.ExtendedLockInfo orgLockInfo)
    throws com.sap.netweaver.bc.rf.common.exception.ResourceException {
    if (orgLockInfo == null) {
      return null;
    }
    return new com.sap.netweaver.bc.rf.mi.lock.LockInfo(orgLockInfo.getLockToken(), RidTransformer.transform(orgLockInfo.getRequestRID()), LockDepthTypeTransformer.transform(orgLockInfo.getDepth()), LockScopeTypeTransformer.transform(orgLockInfo.getScope()), LockKindTypeTransformer.transform(orgLockInfo.getType()), orgLockInfo.getCreated(), orgLockInfo.getTimeout() * 1000L, orgLockInfo.getOwner(), orgLockInfo.getClientSuppliedOwner().toString());
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgLockInfo TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public static com.sapportals.wcm.repository.LockInfo transform(com.sap.netweaver.bc.rf.common.lock.ILockInfo orgLockInfo)
    throws com.sapportals.wcm.repository.ResourceException {
    if (orgLockInfo == null) {
      return null;
    }
    String cso = orgLockInfo.getClientSuppliedOwner();
    return new com.sapportals.wcm.repository.LockInfo(
      LockKindTypeTransformer.transform(orgLockInfo.getKind()),
      LockScopeTypeTransformer.transform(orgLockInfo.getScope()),
      LockDepthTypeTransformer.transform(orgLockInfo.getDepth()),
      orgLockInfo.getOwner(),
      (int)(orgLockInfo.getTimeout() / 1000),
      orgLockInfo.getLockToken(),
      orgLockInfo.getCreationDate(),
      (cso == null) ? (null) : (
      new com.sapportals.wcm.repository.XMLMarkup(cso)));
  }

  public static ILockInfoCollection transformCollection(java.util.List list)
    throws com.sapportals.wcm.repository.ResourceException {
    ILockInfoCollection coll = new LockInfoCollection();
    for (int i = 0, s = list.size(); i < s; i++) {
      coll.add(LockInfoTransformer.transform((com.sap.netweaver.bc.rf.common.lock.ILockInfo)list.get(i)));
    }
    return coll;
  }

}
