/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.lock;

/**
 * TBD: Description of the class.
 *
 * @created 26. Februar 2003
 */
public class LockDescriptorTransformer {
  /**
   * TBD: Description of the Method.
   *
   * @param orgLockProperties TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception com.sap.netweaver.bc.rf.common.exception.ResourceException
   *      Exception raised in failure situation
   */
  public static com.sap.netweaver.bc.rf.common.lock.ILockDescriptor transform(com.sapportals.wcm.repository.ILockProperties orgLockProperties)
    throws com.sap.netweaver.bc.rf.common.exception.ResourceException {
    if (orgLockProperties == null) {
      return null;
    }
    com.sapportals.wcm.repository.XMLMarkup cso = orgLockProperties.getClientSuppliedOwner();
    String owner = cso != null ? cso.toString() : null;
    return new com.sap.netweaver.bc.rf.ci.lock.LockDescriptor(LockDepthTypeTransformer.transform(orgLockProperties.getDepth()), LockScopeTypeTransformer.transform(orgLockProperties.getScope()), LockKindTypeTransformer.transform(orgLockProperties.getType()), orgLockProperties.getTimeout(), owner);
  }

  /**
   * TBD: Description of the Method.
   *
   * @param orgLockDescriptor TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public static com.sapportals.wcm.repository.LockProperties transform(com.sap.netweaver.bc.rf.common.lock.ILockDescriptor orgLockDescriptor)
    throws com.sapportals.wcm.repository.ResourceException {
    if (orgLockDescriptor == null) {
      return null;
    }
    return new com.sapportals.wcm.repository.LockProperties(LockKindTypeTransformer.transform(orgLockDescriptor.getKind()), LockScopeTypeTransformer.transform(orgLockDescriptor.getScope()), LockDepthTypeTransformer.transform(orgLockDescriptor.getDepth()), (int)orgLockDescriptor.getTimeout(), new com.sapportals.wcm.repository.XMLMarkup(orgLockDescriptor.getClientSuppliedOwner()));
  }
}
