/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.exception;
import com.sap.netweaver.bc.rf.common.property.AbstractPropertyException;

import com.sap.netweaver.bc.rf.common.property.PropertyValueOutOfBoundsException;
import com.sapportals.wcm.repository.wrapping.*;
import com.sapportals.wcm.repository.wrapping.property.PropertyNameTransformer;

/**
 * Transforms new exception into old one.
 */
public final class PropertyValueOutOfBoundsExceptionTransformer {
  public static com.sapportals.wcm.repository.PropertyValueTooBigException transform(PropertyValueOutOfBoundsException ex) {
    try {
      return new com.sapportals.wcm.repository.PropertyValueTooBigException(
        ex.getMessage(),
        RidTransformer.transform(((PropertyValueOutOfBoundsException)ex).getRID()),
        PropertyNameTransformer.transform(((PropertyValueOutOfBoundsException)ex).getPropertyName()),
        (int)((PropertyValueOutOfBoundsException)ex).getValueBounds());
    }
    catch (com.sapportals.wcm.repository.ResourceException rex) {
      return new com.sapportals.wcm.repository.PropertyValueTooBigException(
        ex.getMessage(),
        null,
        null,
        (int)((PropertyValueOutOfBoundsException)ex).getValueBounds());
    }
  }
}
