/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.exception;
import com.sap.netweaver.bc.rf.common.property.AbstractPropertyException;

import com.sap.netweaver.bc.rf.common.property.PropertyNameTooLongException;
import com.sapportals.wcm.repository.wrapping.*;

/**
 * Transforms new exception into old one.
 */
public final class PropertyNameTooLongExceptionTransformer {
  public static com.sapportals.wcm.repository.PropertyNameTooLongException transform(PropertyNameTooLongException ex) {
    try {
      return new com.sapportals.wcm.repository.PropertyNameTooLongException(
        ex.getMessage(), RidTransformer.transform(ex.getRID()),
        ((AbstractPropertyException)ex).getPropertyName().getNamespace(),
        ((AbstractPropertyException)ex).getPropertyName().getLocalName(),
        (int)ex.getNamespaceMaxLength(), (int)ex.getLocalNameMaxLength());
    }
    catch (com.sapportals.wcm.repository.ResourceException rex) {
      // RidTransformer has thrown exception: ignore RID
      return new com.sapportals.wcm.repository.PropertyNameTooLongException(
        ex.getMessage(), null,
        ((AbstractPropertyException)ex).getPropertyName().getNamespace(),
        ((AbstractPropertyException)ex).getPropertyName().getLocalName(),
        (int)ex.getNamespaceMaxLength(), (int)ex.getLocalNameMaxLength());
    }
  }
}
