/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.exception;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.wrapping.*;
import com.sapportals.wcm.util.uri.*;

import java.util.*;

/**
 * TBD: Description of the class.
 *
 * @created 14. April 2003
 */
public class IncompleteOperationTransformer {

  /**
   * Get the ridList attribute of the IncompleteOperationTransformer class.
   *
   * @param orgList TBD: Description of the incoming method parameter
   * @return The ridList value
   * @exception ResourceException Exception raised in failure situation
   */
  public static IRidList getRidList(List orgList)
    throws ResourceException {
    IRidList ridList = new RidList();
    for (int i = 0, s = orgList.size(); i < s; i++) {
      ridList.add(
        RidTransformer.transform(
        (com.sap.netweaver.bc.rf.common.IRid)orgList.get(i)));
    }
    return ridList;
  }


  /**
   * Get the resourceErrors attribute of the IncompleteOperationTransformer
   * class.
   *
   * @param exception TBD: Description of the incoming method parameter
   * @return The resourceErrors value
   */
  public static ResourceErrors getResourceErrors(
    com.sap.netweaver.bc.rf.common.exception.OperationNotCompletedException exception) {
    ResourceErrors resultResourceErrors = new ResourceErrors();
    for (Iterator iter = exception.getThrowables().iterator(); iter.hasNext(); ) {
      resultResourceErrors.append(new ResourceException(
        (com.sap.netweaver.bc.rf.common.exception.ResourceException)iter.next()));
    }
    return resultResourceErrors;
  }


  /**
   * TBD: Description of the Method.
   *
   * @param exception TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static com.sapportals.wcm.repository.IncompleteOperationException transform(
    com.sap.netweaver.bc.rf.common.exception.OperationNotCompletedException exception) {
    ResourceException root = null;
    ResourceException next = null;
    for (Iterator iter = exception.getThrowables().iterator(); iter.hasNext(); ) {
      if (next == null) {
        root = next = new ResourceException(
          (com.sap.netweaver.bc.rf.common.exception.ResourceException)iter.next());
      }
      else {
        next.setNextResourceException(
          next = new ResourceException((com.sap.netweaver.bc.rf.common.exception.ResourceException)iter.next()));
      }
    }
    IRidList ridList = new RidList();
    for (Iterator iter = ((List)exception.getPartiallyComputedResult()).iterator(); iter.hasNext(); ) {
      try {
        ridList.add(RidTransformer.transform(((com.sap.netweaver.bc.rf.common.IResourceHandle)iter.next()).getRid()));
      }
      catch (ResourceException resourceException) {
        ;
      }
    }
    com.sapportals.wcm.repository.IncompleteOperationException result =
      new com.sapportals.wcm.repository.IncompleteOperationException(
      exception.getMessage(),
      root,
      (RID)null);
    result.setSuccessfulOperations(ridList);
    return result;
  }
}
