/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.exception;
import com.sap.netweaver.bc.rf.common.content.*;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.lock.*;
import com.sap.netweaver.bc.rf.common.namespace.*;
import com.sap.netweaver.bc.rf.common.property.*;
import com.sap.netweaver.bc.rf.common.security.*;
import com.sap.netweaver.bc.rf.common.security.acl.*;
import com.sapportals.wcm.repository.wrapping.RidTransformer;
import com.sapportals.wcm.repository.wrapping.property.PropertyNameTransformer;
import com.sapportals.wcm.repository.wrapping.security.AccessDeniedTransformer;

/**
 * Transforms a new RMI exception into an old one.
 */
public final class ExceptionTransformer {
  public static com.sapportals.wcm.repository.ResourceException transform(RepositoryException ex) {
    if (ex instanceof OperationNotCompletedException) {
      return IncompleteOperationTransformer.transform((OperationNotCompletedException)ex);
    }
    else if (ex instanceof ResourceNameAlreadyAssignedException) {
      return new com.sapportals.wcm.repository.NameAlreadyExistsException((ResourceNameAlreadyAssignedException)ex);
    }
    else if (ex instanceof ResourceNameInvalidException) {
      return ResourceNameInvalidTransformer.transform((ResourceNameInvalidException)ex);
    }
    else if (ex instanceof ResourceNameUnassignableException) {
      return new com.sapportals.wcm.repository.UnassignableNameException((ResourceNameUnassignableException)ex);
    }
    else if (ex instanceof OperationNotSupportedException) {
      return new com.sapportals.wcm.repository.NotSupportedException((OperationNotSupportedException)ex);
    }
    else if (ex instanceof AccessDeniedException) {
      return AccessDeniedTransformer.transform((AccessDeniedException)ex);
    }
    else if (ex instanceof IOOperationFailedException) {
      return new com.sapportals.wcm.repository.IOErrorException((IOOperationFailedException)ex);
    }
    else if (ex instanceof ServiceNotAvailableException) {
      return new com.sapportals.wcm.repository.ServiceUnavailableException(
        (ServiceNotAvailableException)ex, ((ServiceNotAvailableException)ex).getRetryAfterDate());
    }
    else if (ex instanceof ResourceNotCheckedOutException) {
      return new com.sapportals.wcm.repository.NotCheckedOutException((ResourceNotCheckedOutException)ex);
    }
    else if (ex instanceof ResourceReadOnlyException) {
      try {
        return new com.sapportals.wcm.repository.ResourceReadOnlyException(
          RidTransformer.transform(((ResourceReadOnlyException)ex).getRID()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.ResourceReadOnlyException(
          (com.sapportals.wcm.util.uri.RID)null);
      }
    }
    else if (ex instanceof ContentMetadataMismatchException) {
      // TODO
      throw new java.lang.RuntimeException("ContentMetadataMismatchException");
    }
    else if (ex instanceof PropertyNameTooLongException) {
      return PropertyNameTooLongExceptionTransformer.transform((PropertyNameTooLongException)ex);
    }
    else if (ex instanceof PropertyNameUnassignableException) {
      try {
        return new com.sapportals.wcm.repository.IllegalPropertyNameException(
          ex.getMessage(),
          RidTransformer.transform(((PropertyNameUnassignableException)ex).getRID()),
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getNamespace() : null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getLocalName() : null);
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.IllegalPropertyNameException(
          ex.getMessage(), null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getNamespace() : null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getLocalName() : null);
      }
    }
    else if (ex instanceof PropertyNameInvalidException) {
      try {
        return new com.sapportals.wcm.repository.IllegalPropertyNameException(
          ex.getMessage(),
          RidTransformer.transform(((PropertyNameInvalidException)ex).getRID()),
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getNamespace() : null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getLocalName() : null);
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.IllegalPropertyNameException(
          ex.getMessage(), null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getNamespace() : null,
          ((AbstractPropertyException)ex).getPropertyName() != null ? ((AbstractPropertyException)ex).getPropertyName().getLocalName() : null);
      }
    }
    else if (ex instanceof PropertyValueOutOfBoundsException) {
      return PropertyValueOutOfBoundsExceptionTransformer.transform((PropertyValueOutOfBoundsException)ex);
    }
    else if (ex instanceof PropertyReadOnlyException) {
      try {
        return new com.sapportals.wcm.repository.PropertyReadOnlyException(
          RidTransformer.transform(((PropertyReadOnlyException)ex).getRID()),
          PropertyNameTransformer.transform(((AbstractPropertyException)ex).getPropertyName()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.PropertyReadOnlyException(
          (com.sapportals.wcm.util.uri.RID)null, null);
      }
    }
    else if (ex instanceof PropertyMandatoryException) {
      try {
        return new com.sapportals.wcm.repository.PropertyMandatoryException(
          RidTransformer.transform(((PropertyMandatoryException)ex).getRID()),
          PropertyNameTransformer.transform(((AbstractPropertyException)ex).getPropertyName()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.PropertyMandatoryException(
          (com.sapportals.wcm.util.uri.RID)null, null);
      }
    }
    else if (ex instanceof PropertyTypeLostException) {
      try {
        return new com.sapportals.wcm.repository.PropertyTypeLostException(
          RidTransformer.transform(((PropertyTypeLostException)ex).getRID()),
          PropertyNameTransformer.transform(((AbstractPropertyException)ex).getPropertyName()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.PropertyTypeLostException(
          (com.sapportals.wcm.util.uri.RID)null, null);
      }
    }
    else if (ex instanceof PropertyTypeMismatchException) {
      try {
        return new com.sapportals.wcm.repository.PropertyTypeMismatchException(
          RidTransformer.transform(((PropertyTypeMismatchException)ex).getRID()),
          PropertyNameTransformer.transform(((AbstractPropertyException)ex).getPropertyName()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.PropertyTypeMismatchException(
          (com.sapportals.wcm.util.uri.RID)null, null);
      }
    }
    else if (ex instanceof CollectionOrderImmutableException) {
      try {
        return new com.sapportals.wcm.repository.NotOrderedException(RidTransformer.transform(((CollectionOrderImmutableException)ex).getRID()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.NotOrderedException(null);
      }
    }
    else if (ex instanceof OrderMechanismInvalidException) {
      try {
        return new com.sapportals.wcm.repository.InvalidPositionException(
          ex.getMessage(), RidTransformer.transform(((OrderMechanismInvalidException)ex).getRID()));
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.InvalidPositionException(ex.getMessage(), null);
      }
    }
    else if (ex instanceof LockInPlaceException) {
      try {
        return new com.sapportals.wcm.repository.LockedException(
          ex.getMessage(),
          RidTransformer.transform(((LockInPlaceException)ex).getRID()),
          null);
      }
      catch (com.sapportals.wcm.repository.ResourceException rex) {
        return new com.sapportals.wcm.repository.LockedException(
          ex.getMessage(), (com.sapportals.wcm.util.uri.RID)null, null);
      }
    }
    else if (ex instanceof ResourceException) {
      return new com.sapportals.wcm.repository.ResourceException(ex);
    }
    else {
      throw new RuntimeException("unexpected exception instance: " + ex.getClass().getName());
    }
  }

  public static com.sapportals.wcm.util.acl.AclException transformAclException(AclException ex) {
    if (ex instanceof AclPersistenceException) {
      return new com.sapportals.wcm.util.acl.AclPersistenceException(ex.getMessage());
    }
    else if (ex instanceof AclAlreadyAssignedToAclException) {
      return new com.sapportals.wcm.util.acl.AlreadyAssignedToAclException();
    }
    else if (ex instanceof AclExistsException) {
      return new com.sapportals.wcm.util.acl.AclExistsException();
    }
    else if (ex instanceof AclLastOwnerException) {
      return new com.sapportals.wcm.util.acl.LastOwnerException();
    }
    else if (ex instanceof AclNotAuthorizedException) {
      return new com.sapportals.wcm.util.acl.NotAuthorizedException();
    }
    else if (ex instanceof AclPermissionExistsException) {
      return new com.sapportals.wcm.util.acl.PermissionExistsException();
    }
    else if (ex instanceof AclPermissionNotSupportedException) {
      return new com.sapportals.wcm.util.acl.PermissionNotSupportedException();
    }
    else if (ex instanceof AclPermissionUsedException) {
      return new com.sapportals.wcm.util.acl.PermissionUsedException();
    }
    else if (ex instanceof AclPredefinedPermissionException) {
      return new com.sapportals.wcm.util.acl.PredefinedPermissionException();
    }
    else if (ex instanceof AclException) {
      return new com.sapportals.wcm.util.acl.AclException(ex.getMessage());
    }
    else {
      throw new RuntimeException("unexpected exception instance: " + ex.getClass().getName());
    }
  }
}
