/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.exception;

import com.sap.netweaver.bc.rf.common.exception.*;
import com.sap.netweaver.bc.rf.common.security.*;
import com.sap.netweaver.bc.rf.common.security.acl.*;

/**
 * Transforms a new ACL exception into an old one.
 */
public final class AclExceptionTransformer {
  public static com.sapportals.wcm.util.acl.AclException transform(AclException ex) {
    if (ex instanceof AclPersistenceException) {
      return new com.sapportals.wcm.util.acl.AclPersistenceException(ex.getMessage());
    }
    else if (ex instanceof AclAlreadyAssignedToAclException) {
      return new com.sapportals.wcm.util.acl.AlreadyAssignedToAclException();
    }
    else if (ex instanceof AclExistsException) {
      return new com.sapportals.wcm.util.acl.AclExistsException();
    }
    else if (ex instanceof AclLastOwnerException) {
      return new com.sapportals.wcm.util.acl.LastOwnerException();
    }
    else if (ex instanceof AclNotAuthorizedException) {
      return new com.sapportals.wcm.util.acl.NotAuthorizedException();
    }
    else if (ex instanceof AclPermissionExistsException) {
      return new com.sapportals.wcm.util.acl.PermissionExistsException();
    }
    else if (ex instanceof AclPermissionNotSupportedException) {
      return new com.sapportals.wcm.util.acl.PermissionNotSupportedException();
    }
    else if (ex instanceof AclPermissionUsedException) {
      return new com.sapportals.wcm.util.acl.PermissionUsedException();
    }
    else if (ex instanceof AclPredefinedPermissionException) {
      return new com.sapportals.wcm.util.acl.PredefinedPermissionException();
    }
    else if (ex instanceof AclException) {
      return new com.sapportals.wcm.util.acl.AclException(ex.getMessage());
    }
    else {
      throw new RuntimeException("unexpected exception instance: " + ex.getClass().getName());
    }
  }
}
