/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.content;

import com.sap.netweaver.bc.rf.common.content.*;
import com.sap.netweaver.bc.rf.common.exception.*;
import java.io.InputStream;
import java.util.Date;

/**
 * TBD: Description of the class.
 *
 * @created 14. April 2003
 */
public class ContentWrapperOut
   implements
  com.sapportals.wcm.util.content.IContent,
  com.sapportals.wcm.repository.IEntityMetadata {

  private final IContent content;

  /**
   * Construct object of class ContentWrapperOut.
   *
   * @param content TBD: Description of the incoming method parameter
   */
  ContentWrapperOut(IContent content) {
    if (content == null) {
      throw new NullPointerException("parameter content is null");
    }
    this.content = content;
  }

  // --- IContent ---

  /**
   * Get the inputStream attribute of the ContentWrapperOut object.
   *
   * @return The inputStream value
   * @exception com.sapportals.wcm.util.content.ContentException Exception
   *      raised in failure situation
   */
  public InputStream getInputStream()
    throws com.sapportals.wcm.util.content.ContentException {
    try {
      return this.content.getInputStream();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.util.content.ContentException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * Get the contentLength attribute of the ContentWrapperOut object.
   *
   * @return The contentLength value
   * @exception com.sapportals.wcm.util.content.ContentException Exception
   *      raised in failure situation
   */
  public long getContentLength()
    throws com.sapportals.wcm.util.content.ContentException {
    try {
      return this.content.getContentMetadata().getContentLength();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.util.content.ContentException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * Get the contentType attribute of the ContentWrapperOut object.
   *
   * @return The contentType value
   * @exception com.sapportals.wcm.util.content.ContentException Exception
   *      raised in failure situation
   */
  public String getContentType()
    throws com.sapportals.wcm.util.content.ContentException {
    try {
      return this.content.getContentMetadata().getContentType();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.util.content.ContentException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * Get the encoding attribute of the ContentWrapperOut object.
   *
   * @return The encoding value
   * @exception com.sapportals.wcm.util.content.ContentException Exception
   *      raised in failure situation
   */
  public String getEncoding()
    throws com.sapportals.wcm.util.content.ContentException {
    try {
      return this.content.getContentMetadata().getContentEncoding();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.util.content.ContentException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * TBD: Description of the Method.
   */
  public void close() { }

  // --- IEntityMetadata ---

  /**
   * Get the entityTag attribute of the ContentWrapperOut object.
   *
   * @return The entityTag value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public String getEntityTag()
    throws com.sapportals.wcm.repository.ResourceException {
    try {
      return this.content.getContentMetadata().getETag();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.repository.ResourceException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * Get the expiryDate attribute of the ContentWrapperOut object.
   *
   * @return The expiryDate value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public Date getExpiryDate()
    throws com.sapportals.wcm.repository.ResourceException {
    try {
      return this.content.getContentMetadata().getExpires();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.repository.ResourceException(
        ex.getMessage(),
        ex);
    }

  }

  /**
   * Get the language attribute of the ContentWrapperOut object.
   *
   * @return The language value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public String getLanguage()
    throws com.sapportals.wcm.repository.ResourceException {
    try {
      return this.content.getContentMetadata().getContentLanguage();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.repository.ResourceException(
        ex.getMessage(),
        ex);
    }
  }

  /**
   * Get the lastModified attribute of the ContentWrapperOut object.
   *
   * @return The lastModified value
   * @exception com.sapportals.wcm.repository.ResourceException Exception raised
   *      in failure situation
   */
  public Date getLastModified()
    throws com.sapportals.wcm.repository.ResourceException {
    try {
      return this.content.getContentMetadata().getLastModified();
    }
    catch (ResourceException ex) {
      throw new com.sapportals.wcm.repository.ResourceException(
        ex.getMessage(),
        ex);
    }
  }
}
