/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping.content;

import com.sap.netweaver.bc.rf.common.content.*;

/**
 * Provides wrapper for content objects.
 *
 * @created 14. April 2003
 */
public final class ContentTransformer {

  /**
   * TBD: Description of the Method.
   *
   * @param content TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static IMutableContent transform(com.sapportals.wcm.util.content.IContent content) {
    if (content == null) {
      return null;
    }
    return new ContentWrapperIn(content);
  }

  /**
   * TBD: Description of the Method.
   *
   * @param content TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public static com.sapportals.wcm.util.content.IContent transform(IContent content) {
    if (content == null) {
      return null;
    }
    return new ContentWrapperOut(content);
  }
}
