/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.wrapping;

import com.sap.netweaver.bc.rf.common.exception.ResourceException;
import com.sapportals.wcm.util.uri.RID;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Transforms RID list objects.
 */
public class RidSetTransformer {

  public static Set transform(com.sapportals.wcm.util.uri.IRidSet s)
    throws ResourceException {
    if (s == null) {
      return null;
    }
    Set set = new HashSet(s.size());
    com.sapportals.wcm.util.uri.IRidIterator it = s.iterator();
    while (it.hasNext()) {
      set.add(RidTransformer.transform((RID)it.next()));
    }
    return set;
  }


  public static com.sapportals.wcm.util.uri.IRidSet transform(Set s) {
    return null;
  }
}
