/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.so;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.repository.*;
import java.util.HashMap;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
/**
 * @todo: Description of the class.
 */
public class ObjectFactoryRegistryCore implements IObjectFactoryRegistry {

  protected IMutableObjectFactory dof = new DefaultObjectFactory();
  protected List factoryList = new Vector();

  /**
   * @todo: Description of the Method.
   */
  public ObjectFactoryRegistryCore() {
    factoryList.add(dof);
  }

  /**
   * @param factory
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   */
  public void registerObjectFactory(IObjectFactory factory) {
    factoryList.add(factory);
  }

  public IMutableObjectFactory getDefaultObjectFactory() {
    return this.dof;
  }

  /**
   * @return
   * @todo: Description of the Method.
   * @todo: Description of the outgoing return value
   */
  public ListIterator factoryListIterator() {
    return factoryList.listIterator();
  }

  public boolean isA(Class cl, IResource res)
    throws WcmException {
    ListIterator iter = this.factoryListIterator();
    while (iter.hasNext()) {
      IObjectFactory prov = (IObjectFactory)iter.next();
      if (true == prov.isA(cl, res)) {
        return true;
      }
    }
    return false;
  }

  public Object as(Class cl, IResource res)
    throws WcmException {
    ListIterator iter = this.factoryListIterator();
    Object so = null;
    while (iter.hasNext()) {
      IObjectFactory prov = (IObjectFactory)iter.next();
      if (null != (so = prov.as(cl, res))) {
        return so;
      }
    }
    return null;
  }
}
