/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.security;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.util.acl.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;


/**
 * Implementation of a <code>IResourceAclRaw</code>. <br>
 */
public final class ResourceAclRaw
extends ResourceAcl
implements IResourceAclRaw {

  // =========
  // Constants ================================================================
  // =========

  private static final IResourceAclEntryList EMPTY_LIST = new ResourceAclEntryList();
  

  // ==================
  // Instance Variables =======================================================
  // ==================
  
  private final IAclRaw raw_acl;
  

  // ===============
  // Private Methods ==========================================================
  // ===============
  
  // ------------------------------------------------------------------------
  private IResourceAclEntryList createResourceAclEntryRawList(IAclEntryList entries)
                                                       throws AclPersistenceException {

    if (entries == null) {
      return EMPTY_LIST;
    }

    ResourceAclEntryList result = new ResourceAclEntryList();
    IAclEntryListIterator iterator = entries.iterator();
    while( iterator.hasNext() ) {
      IAclEntry entry = iterator.next();
      ResourceAclEntry newEntry = ( entry instanceof IAclEntryRaw ) 
                                  ? new ResourceAclEntryRaw(entry)
                                  : new ResourceAclEntry(entry);
      newEntry.setAcl(this);
      result.add(newEntry);
    }

    return result;

  }


  // =================
  // Protected Methods ========================================================
  // =================

  // ------------------------------------------------------------------------
  protected IAclRaw getAclRaw() {
    return this.raw_acl;
  }


  // ============
  // Constructors =============================================================
  // ============

  // ------------------------------------------------------------------------
  /**
   * Construct a <code>ResourceAclRaw</code>.
   * @param rsrcAclManager
   * @param resource
   * @param acl
   */
  public ResourceAclRaw(ResourceAclManager rsrcAclManager,
                        IResource resource,
                        IAclRaw acl) {
    super(rsrcAclManager, resource, acl);
    this.raw_acl = acl;
  }


  // ===============
  // IResourceAclRaw ==========================================================
  // ===============

  // ------------------------------------------------------------------------
  public IUMPrincipalList getOwnersRaw()
                                throws AclPersistenceException {
    return this.raw_acl.getOwnersRaw();
  }


  // ------------------------------------------------------------------------
  public IResourceAclEntryList getEntriesRaw()
                                      throws AclPersistenceException {
    return createResourceAclEntryRawList(this.raw_acl.getEntriesRaw());
  }


}
