/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.security;

import com.sapportals.wcm.repository.manager.*;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public final class ResourceAclEntryList implements IResourceAclEntryList {

  private List m_list = null;
  private boolean m_containsRaw = false;


  public ResourceAclEntryList() {
    m_list = new LinkedList();
    m_containsRaw = false;
  }

  public void add(IResourceAclEntry aclEntry) {
    m_list.add(aclEntry);
    if(   ( m_containsRaw == false )
       && ( aclEntry instanceof IResourceAclEntryRaw )
      ) {
      m_containsRaw = true; 
    }
  }

  public boolean containsRawEntries() {
    return m_containsRaw;
  }

  public IResourceAclEntryListIterator iterator() {
    return new ResourceAclEntryListIterator(m_list.iterator());
  }
  
}
