/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.security;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public class ResourceAclEntry implements IResourceAclEntry {
  private ResourceAcl m_acl = null;
  private IAclEntry m_aclEntry = null;


  public ResourceAclEntry(IAclEntry aclEntry) {
    if (aclEntry == null) {
      throw new NullPointerException();
    }

    m_aclEntry = aclEntry;
  }

  public final IAclPermission getPermission()
    throws AclPersistenceException {
    return m_aclEntry.getPermission();
  }

  public final boolean checkPermission(IAclPermission permission)
    throws AclPersistenceException, InvalidClassException {
    return m_aclEntry.checkPermission(permission);
  }

  public final boolean isNegative()
    throws AclPersistenceException {
    return m_aclEntry.isNegative();
  }

  public final IUMPrincipal getPrincipal()
    throws AclPersistenceException {
    return m_aclEntry.getPrincipal();
  }

  public final boolean isReadOnly()
    throws AclPersistenceException {
    return m_aclEntry.isReadOnly();
  }

  public final int getSortIndex()
    throws AclPersistenceException {
    return m_aclEntry.getSortIndex();
  }

  public final void setSortIndex(int sortIndex)
    throws AclPersistenceException, NotAuthorizedException {
    m_aclEntry.setSortIndex(m_acl != null ? ResourceAclManager.getLoggedInUser(m_acl.getResource()) : null, sortIndex);
  }

  /*
   * removed from interface
   * public boolean isPropagated()
   * {
   * return m_aclEntry.isPropagated();
   * }
   * public void setPropagation(boolean propagate) throws NotAuthorizedException
   * {
   * m_aclEntry.setPropagation(m_acl!=null ? ResourceAclManager.getLoggedInUser(m_acl.getResource()) : null,propagate);
   * }
   */
  protected final IAclEntry getAclEntry() {
    return m_aclEntry;
  }

  protected final void setAcl(ResourceAcl acl) {
    m_acl = acl;
  }
}
