/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.security;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * Copyright (c) SAP AG 2002
 *
 * @author Dirk Sabiwalsky
 * @version $Id: ResourceAcl.java,v 1.8 2002/08/30 12:48:32 sei Exp $
 */
public class ResourceAcl implements IResourceAcl {

  private final IAcl m_acl;
  private final IResource m_resource;
  private final IUser m_user;
  private final ResourceAclManager m_rsrcAclManager;

  /**
   * Construct object of class ResourceAcl.
   *
   * @param rsrcAclManager
   * @param resource
   * @param acl
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public ResourceAcl(ResourceAclManager rsrcAclManager, IResource resource, IAcl acl) {
    if (rsrcAclManager == null || resource == null || acl == null) {
      throw new java.lang.IllegalArgumentException();
    }

    m_rsrcAclManager = rsrcAclManager;
    m_acl = acl;
    m_resource = resource;
    m_user = ResourceAclManager.getLoggedInUser(m_resource);
  }

  /**
   * Construct object of class ResourceAcl.
   *
   * @param rsrcAclManager
   * @param acl
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  protected ResourceAcl(ResourceAclManager rsrcAclManager, IAcl acl) {
    if (rsrcAclManager == null || acl == null) {
      throw new java.lang.IllegalArgumentException();
    }

    m_rsrcAclManager = rsrcAclManager;
    m_acl = acl;
    m_resource = null;
    m_user = null;
  }

  public final boolean isOwner(IUMPrincipal principal)
    throws AclPersistenceException {
    if (principal == null) {
      throw new java.lang.IllegalArgumentException();
    }
    return m_acl.isOwner(principal);
  }

  public final boolean isAuthorized(IUMPrincipal principal)
    throws AclPersistenceException {
    if (principal == null) {
      throw new java.lang.IllegalArgumentException();
    }
    return m_acl.isAuthorized(principal);
  }

  public final IUMPrincipalList getOwners()
    throws AclPersistenceException {
    return m_acl.getOwners();
  }

  public final IResourceAclEntryList getEntries()
    throws AclPersistenceException {
    return createResourceAclEntryList(m_acl.getEntries());
  }

  public final IResourceAclEntryList getEntries(IUMPrincipal principal)
    throws AclPersistenceException {
    if (principal == null) {
      throw new java.lang.IllegalArgumentException();
    }
    return createResourceAclEntryList(m_acl.getEntries(principal));
  }

  public final boolean isReadOnly()
    throws AclPersistenceException {
    return m_acl.isReadOnly();
  }

  public final IResource getResource() {
    return m_resource;
  }

  public final boolean isLocked()
    throws AclPersistenceException {
    return m_acl.isLocked();
  }

  public final IUMPrincipal getLockingUser()
    throws AclPersistenceException {
    return m_acl.getLockingUser();
  }

  public final boolean addOwner(IUMPrincipal owner)
    throws AclPersistenceException, NotAuthorizedException, ResourceException {
    if (owner == null) {
      throw new java.lang.IllegalArgumentException();
    }
    if (m_resource == null) {
      throw new java.lang.IllegalStateException();
    }
    if (!m_acl.addOwner(m_user, owner)) {
      return false;
    }

    m_rsrcAclManager.aclChanged(m_resource);
    return true;
  }

  public final boolean removeOwner(IUMPrincipal owner)
    throws AclPersistenceException, NotAuthorizedException, LastOwnerException, ResourceException {
    if (owner == null) {
      throw new java.lang.IllegalArgumentException();
    }
    if (m_resource == null) {
      throw new java.lang.IllegalStateException();
    }
    if (!m_acl.removeOwner(m_user, owner)) {
      return false;
    }
    m_rsrcAclManager.aclChanged(m_resource);
    return true;
  }

  public final boolean addEntry(IResourceAclEntry aclEntry)
    throws AclPersistenceException, InvalidClassException, NotAuthorizedException, AlreadyAssignedToAclException, PermissionNotSupportedException, ResourceException {
    if (aclEntry == null) {
      throw new java.lang.IllegalArgumentException();
    }
    if (m_resource == null) {
      throw new java.lang.IllegalStateException();
    }
    if (!(aclEntry instanceof ResourceAclEntry)) {
      throw new InvalidClassException();
    }
    if (!m_acl.addEntry(m_user, ((ResourceAclEntry)aclEntry).getAclEntry())) {
      return false;
    }
    ((ResourceAclEntry)aclEntry).setAcl(this);
    m_rsrcAclManager.aclChanged(m_resource);
    return true;
  }

  public final boolean removeEntry(IResourceAclEntry aclEntry)
    throws AclPersistenceException, InvalidClassException, NotAuthorizedException, ResourceException {
    if (aclEntry == null) {
      throw new java.lang.IllegalArgumentException();
    }
    if (m_resource == null) {
      throw new java.lang.IllegalStateException();
    }
    if (!(aclEntry instanceof ResourceAclEntry)) {
      throw new InvalidClassException();
    }
    if (!m_acl.removeEntry(m_user, ((ResourceAclEntry)aclEntry).getAclEntry())) {
      return false;
    }
    ((ResourceAclEntry)aclEntry).setAcl(null);
    m_rsrcAclManager.aclChanged(m_resource);
    return true;
  }

  public final boolean checkPermission(IUMPrincipal user, IAclPermission permission)
    throws AclPersistenceException {
    if (user == null || permission == null) {
      throw new java.lang.IllegalArgumentException();
    }
    return m_acl.checkPermission(user, permission);
  }

  public final boolean lock()
    throws AclPersistenceException, NotAuthorizedException {
    if (m_user == null) {
      throw new java.lang.IllegalStateException();
    }
    return m_acl.lock(m_user);
  }

  public final void unlock()
    throws AclPersistenceException, NotAuthorizedException {
    if (m_user == null) {
      throw new java.lang.IllegalStateException();
    }
    m_acl.unlock(m_user);
  }

  public final boolean isUpToDate()
    throws AclPersistenceException {
    return m_acl.isUpToDate();
  }

  /**
   * Get the Acl attribute of the ResourceAcl object.
   *
   * @return The Acl value
   */
  protected final IAcl getAcl() {
    return m_acl;
  }

  /*
   * removed from interface:
   * public boolean hasDescendantsWithAcl() throws AclPersistenceException
   * {
   * return m_acl.hasDescendantsWithAcl("/");
   * }
   * public List getDescendantsWithAcl() throws AclPersistenceException // return list of Strings
   * {
   * return m_acl.getDescendantsWithAcl("/");
   * }
   */
  /**
   * @param entries
   * @return
   * @exception AclPersistenceException Exception raised in failure situation
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  private IResourceAclEntryList createResourceAclEntryList(IAclEntryList entries)
    throws AclPersistenceException {

    if (entries == null) {
      throw new java.lang.IllegalArgumentException();
    }
    if (entries == null) {
      return null;
    }

    ResourceAclEntryList result = new ResourceAclEntryList();
    IAclEntryListIterator iterator = entries.iterator();
    while (iterator != null && iterator.hasNext()) {
      IAclEntry entry = iterator.next();
      ResourceAclEntry newEntry = new ResourceAclEntry(entry);
      newEntry.setAcl(this);
      result.add(newEntry);
    }
    return result;
  }


}
