/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.search;

import com.sapportals.wcm.repository.*;

/**
 * Builds query expressions for the Simple Property Search Manager. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author julian.reschke@greenbytes.de
 * @version $Id: SimpleQueryBuilder.java,v 1.3 2004/07/02 09:01:31 jre Exp $
 */
final class SimpleQueryBuilder implements IQueryBuilder, IMultiValueQueryBuilder {

  // eq

  public IQueryExpression eq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Eq(name, value, true, false);
  }

  public IQueryExpression someEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Eq(name, value, true, true);
  }

  public IQueryExpression eq(IPropertyName name, String value) {
    return new SimpleQueryExpression.Eq(name, value, true, false);
  }

  public IQueryExpression eqIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.Eq(name, value, false, false);
  }

  public IQueryExpression someEqIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Eq(name, value, false, true);
  }

  // ne

  public IQueryExpression notEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.NotEq(name, value, true, false);
  }

  public IQueryExpression someNotEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.NotEq(name, value, true, true);
  }

  public IQueryExpression notEq(IPropertyName name, String value) {
    return new SimpleQueryExpression.NotEq(name, value, true, false);
  }

  public IQueryExpression notEqIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.NotEq(name, value, false, false);
  }

  public IQueryExpression someNotEqIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.NotEq(name, value, false, true);
  }

  // less

  public IQueryExpression less(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Less(name, value, true, false);
  }

  public IQueryExpression someLess(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Less(name, value, true, true);
  }

  public IQueryExpression less(IPropertyName name, String value) {
    return new SimpleQueryExpression.Less(name, value, true, false);
  }

  public IQueryExpression lessIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.Less(name, value, false, false);
  }

  public IQueryExpression someLessIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Less(name, value, false, true);
  }

  // less eq

  public IQueryExpression lessEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.LessEq(name, value, true, false);
  }

  public IQueryExpression someLessEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.LessEq(name, value, true, true);
  }

  public IQueryExpression lessEq(IPropertyName name, String value) {
    return new SimpleQueryExpression.LessEq(name, value, true, false);
  }

  public IQueryExpression lessEqIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.LessEq(name, value, false, false);
  }

  public IQueryExpression someLessEqIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.LessEq(name, value, false, true);
  }

  // greater

  public IQueryExpression greater(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Greater(name, value, true, false);
  }

  public IQueryExpression someGreater(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Greater(name, value, true, true);
  }

  public IQueryExpression greater(IPropertyName name, String value) {
    return new SimpleQueryExpression.Greater(name, value, true, false);
  }

  public IQueryExpression greaterIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.Greater(name, value, false, false);
  }

  public IQueryExpression someGreaterIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.Greater(name, value, false, true);
  }

  // greater eq

  public IQueryExpression greaterEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.GreaterEq(name, value, true, false);
  }

  public IQueryExpression someGreaterEq(IPropertyName name, Object value) {
    return new SimpleQueryExpression.GreaterEq(name, value, true, true);
  }

  public IQueryExpression greaterEq(IPropertyName name, String value) {
    return new SimpleQueryExpression.GreaterEq(name, value, true, false);
  }

  public IQueryExpression greaterEqIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.GreaterEq(name, value, false, false);
  }

  public IQueryExpression someGreaterEqIgnoreCase(IPropertyName name, Object value) {
    return new SimpleQueryExpression.GreaterEq(name, value, false, true);
  }

  // not

  public IQueryExpression not(IQueryExpression expression) {
    return new SimpleQueryExpression.Not(expression);
  }

  // like

  public IQueryExpression like(IPropertyName name, String value) {
    return new SimpleQueryExpression.Like(name, value, true, false);
  }

  public IQueryExpression someLike(IPropertyName name, String value) {
    return new SimpleQueryExpression.Like(name, value, true, true);
  }

  public IQueryExpression likeIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.Like(name, value, false, false);
  }

  public IQueryExpression someLikeIgnoreCase(IPropertyName name, String value) {
    return new SimpleQueryExpression.Like(name, value, false, true);
  }

  // other

  public IQueryExpression isDefined(IPropertyName name) {
    return new SimpleQueryExpression.IsDefined(name);
  }

  public IQueryExpression isCollection() {
    return new SimpleQueryExpression.IsCollection();
  }

  public IQueryExpression constFalse() {
    return new SimpleQueryExpression.ConstFalse();
  }

  public IQueryExpression constTrue() {
    return new SimpleQueryExpression.ConstTrue();
  }
}
