/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.search;

import com.sapportals.wcm.repository.IMultiValueQueryBuilder;
import com.sapportals.wcm.repository.IPropertyName;
import com.sapportals.wcm.repository.IQueryBuilder;
import com.sapportals.wcm.repository.IQueryExpression;

/**
 * <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: PersistentQueryBuilder.java,v 1.3 2003/02/17 17:11:32 jre Exp $
 */
public class PersistentQueryBuilder implements IQueryBuilder, IMultiValueQueryBuilder {

  public IQueryExpression eq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.Eq(name, value, true);
  }

  public IQueryExpression eq(IPropertyName name, String value) {
    return new PersistentQueryExpression.Eq(name, value, true);
  }

  public IQueryExpression eqIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.Eq(name, value, false);
  }

  public IQueryExpression notEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.NotEq(name, value, true);
  }

  public IQueryExpression notEq(IPropertyName name, String value) {
    return new PersistentQueryExpression.NotEq(name, value, true);
  }

  public IQueryExpression notEqIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.NotEq(name, value, false);
  }

  public IQueryExpression less(IPropertyName name, Object value) {
    return new PersistentQueryExpression.Less(name, value, true);
  }

  public IQueryExpression less(IPropertyName name, String value) {
    return new PersistentQueryExpression.Less(name, value, true);
  }

  public IQueryExpression lessIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.Less(name, value, false);
  }

  public IQueryExpression lessEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.LessEq(name, value, true);
  }

  public IQueryExpression lessEq(IPropertyName name, String value) {
    return new PersistentQueryExpression.LessEq(name, value, true);
  }

  public IQueryExpression lessEqIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.LessEq(name, value, false);
  }

  public IQueryExpression greater(IPropertyName name, Object value) {
    return new PersistentQueryExpression.Greater(name, value, true);
  }

  public IQueryExpression greater(IPropertyName name, String value) {
    return new PersistentQueryExpression.Greater(name, value, true);
  }

  public IQueryExpression greaterIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.Greater(name, value, false);
  }

  public IQueryExpression greaterEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.GreaterEq(name, value, true);
  }

  public IQueryExpression greaterEq(IPropertyName name, String value) {
    return new PersistentQueryExpression.GreaterEq(name, value, true);
  }

  public IQueryExpression greaterEqIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.GreaterEq(name, value, false);
  }

  public IQueryExpression not(IQueryExpression expression) {
    return new PersistentQueryExpression.Not(expression);
  }

  public IQueryExpression like(IPropertyName name, String value) {
    return new PersistentQueryExpression.Like(name, value, true);
  }

  public IQueryExpression likeIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.Like(name, value, false);
  }

  public IQueryExpression isDefined(IPropertyName name) {
    return new PersistentQueryExpression.IsDefined(name);
  }

  public IQueryExpression isCollection() {
    return new PersistentQueryExpression.IsCollection();
  }

  public IQueryExpression constFalse() {
    return new PersistentQueryExpression.ConstFalse();
  }

  public IQueryExpression constTrue() {
    return new PersistentQueryExpression.ConstTrue();
  }

  public IQueryExpression someEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeEq(name, value, true);
  }

  public IQueryExpression someEqIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeEq(name, value, false);
  }

  public IQueryExpression someNotEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeNotEq(name, value, true);
  }

  public IQueryExpression someNotEqIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeNotEq(name, value, false);
  }

  public IQueryExpression someLess(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeLess(name, value, true);
  }

  public IQueryExpression someLessIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeLess(name, value, false);
  }

  public IQueryExpression someLessEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeLessEq(name, value, true);
  }

  public IQueryExpression someLessEqIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeLessEq(name, value, false);
  }

  public IQueryExpression someGreater(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeGreater(name, value, true);
  }

  public IQueryExpression someGreaterIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeGreater(name, value, false);
  }

  public IQueryExpression someGreaterEq(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeGreaterEq(name, value, true);
  }

  public IQueryExpression someGreaterEqIgnoreCase(IPropertyName name, Object value) {
    return new PersistentQueryExpression.SomeGreaterEq(name, value, false);
  }

  public IQueryExpression someLike(IPropertyName name, String value) {
    return new PersistentQueryExpression.SomeLike(name, value, true);
  }

  public IQueryExpression someLikeIgnoreCase(IPropertyName name, String value) {
    return new PersistentQueryExpression.SomeLike(name, value, false);
  }

}
