/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime.legacy;
import com.sapportals.wcm.IWcmConst;

import com.sapportals.wcm.crt.component.*;
import com.sapportals.wcm.crt.configuration.*;
import com.sapportals.wcm.service.AbstractService;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;

/**
 * @author Jens Kaiser
 * @version $Id:$
 */
public class ServiceProxy extends AbstractProxy {
  public void contextualize(IContext context) {
    super.contextualize(context);
    // Fetch the lifestyle mode without instantiating the service
    Integer lifestyle = null;
    try {
      Method method = this.legacyClass.getMethod("getInstanceType", null);
      lifestyle = (Integer)method.invoke(null, null);
    }
    catch (Exception x) {
      CAT.errorT("contextualize(41)", x.getMessage() + ": " + LoggingFormatter.extractCallstack(x));
    }
    if (lifestyle != null && lifestyle.intValue() == IWcmConst.INSTANCE_TYPE_SINGLETON) {
      CAT.debugT("contextualize(44)", "service " + this.legacyClass + " is thread safe");
      addInterface(IThreadSafe.class);
    }
    // Autostart by default - you never know...
    addInterface(IAutoStartable.class);
    // Add service redirectors
    addRedirection(IConfigurable.class, ServiceProxy.class, "configure",
      new Class[]{IConfiguration.class});
  }

  public void configure(IConfiguration configuration) {
    Properties properties = convertConfigToProperties(configuration);
    try {
      Constructor legacyConstructor = this.legacyClass.getConstructor(
        new Class[]{Properties.class});
      this.legacyObject = legacyConstructor.newInstance(
        new Object[]{properties});
      ((AbstractService)this.legacyObject).configure(configuration);
    }
    catch (Throwable x) {
      CAT.errorT("configure(64)", x.getMessage() + ": " + LoggingFormatter.extractCallstack(x));
    }
  }

  public static boolean isLegacyClass(Class service) {
    if (!AbstractService.class.isAssignableFrom(service)) {
      return false;
    }
    try {
      service.getConstructor(new Class[]{Properties.class});
      service.getMethod("getInstanceType", null);
      return true;
    }
    catch (NoSuchMethodException x) {
      return false;
    }

  }
}
