/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime.legacy;
import com.sapportals.wcm.IWcmConst;

import com.sapportals.wcm.crt.component.*;
import com.sapportals.wcm.crt.configuration.*;
import com.sapportals.wcm.repository.service.AbstractRepositoryService;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

/**
 * @author Jens Kaiser
 * @version $Id:$
 */
public class RepositoryServiceProxy extends AbstractProxy {
  public void contextualize(IContext context) {
    super.contextualize(context);
    // Add service redirectors
    addRedirection(IConfigurable.class, RepositoryServiceProxy.class, "configure",
      new Class[]{IConfiguration.class});
  }

  public void configure(IConfiguration configuration) {
    Properties properties = convertConfigToProperties(configuration);
    try {
      Constructor legacyConstructor = this.legacyClass.getConstructor(
        new Class[]{Properties.class});
      this.legacyObject = legacyConstructor.newInstance(
        new Object[]{properties});
      ((AbstractRepositoryService)this.legacyObject).configure(configuration);
    }
    catch (Exception x) {
      CAT.errorT("configure(50)", x.getMessage() + ": " + LoggingFormatter.extractCallstack(x));
    }
  }

  public static boolean isLegacyClass(Class repositoryService) {
    if (!AbstractRepositoryService.class.isAssignableFrom(repositoryService)) {
      return false;
    }
    try {
      repositoryService.getConstructor(
        new Class[]{Properties.class});
      return true;
    }
    catch (NoSuchMethodException x) {
      return false;
    }
  }
}
