/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime.legacy;

import com.sap.tc.logging.Location;

import com.sapportals.wcm.crt.component.*;
import com.sapportals.wcm.crt.configuration.IConfiguration;
import com.sapportals.wcm.util.logging.LoggingFormatter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

/**
 * @author Jens Kaiser
 * @version $Id:$
 */
public abstract class AbstractProxy implements IComponent, IProxy {
  protected Class legacyClass;
  protected Object legacyObject;
  protected HashMap redirections;

  private ArrayList interfaces;

  protected static Location CAT = Location.getLocation(com.sapportals.wcm.repository.runtime.legacy.AbstractProxy.class);

  public Object invoke(Object proxy, Method m, Object[] args)
    throws Throwable {
    Object obj = this.legacyObject;
    if (this.redirections.containsKey(m)) {
      obj = this;
      m = (Method)this.redirections.get(m);
    }
    try {
      return m.invoke(obj, args);
    }
    catch (InvocationTargetException x) {
      throw x.getTargetException();
    }
    catch (Exception x) {
      throw new RuntimeException("unexpected invocation exception: " + x.getMessage());
    }
  }

  public void contextualize(IContext context) {
    this.legacyClass = context.getComponentClass();
    this.interfaces = new ArrayList();
    this.redirections = new HashMap();
    addInterfaceClosure(legacyClass);
    addInterface(IComponent.class);
  }

  public Class[] getInterfaces() {
    return (Class[])this.interfaces.toArray(new Class[this.interfaces.size()]);
  }

  protected void addInterface(Class newInterface) {
    if (!this.interfaces.contains(newInterface)) {
      this.interfaces.add(newInterface);
    }
  }

  protected void addRedirection(Class interfaceClass, Class implementorClass, String name, Class[] parameterTypes) {
    try {
      Method legacyMethod = interfaceClass.getMethod(name, parameterTypes);
      Method newMethod = implementorClass.getMethod(name, parameterTypes);
      this.redirections.put(legacyMethod, newMethod);
    }
    catch (NoSuchMethodException x) {
      CAT.errorT("addRedirection(87)", x.getMessage() + ": " + LoggingFormatter.extractCallstack(x));
    }
  }

  protected void addInterfaceClosure(Class clazz) {
    if (clazz.getSuperclass() != null) {
      addInterfaceClosure(clazz.getSuperclass());
    }
    Class[] interfaces = clazz.getInterfaces();
    for (int i = 0; i < interfaces.length; i++) {
      addInterface(interfaces[i]);
    }
  }

  /**
   * Helper method for conversion of configuration data into properties.
   *
   * @param config TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public final static Properties convertConfigToProperties(IConfiguration config) {
    Properties props = new Properties();
    String[] attributeNames = config.getAttributeNames();
    for (int i = 0; i < attributeNames.length; i++) {
      String name = attributeNames[i];
      String value = config.getAttribute(name, null);
      if (value != null) {
        props.setProperty(name, value);
      }
    }
    return props;
  }
}
