/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;

import com.sap.netweaver.bc.rf.common.IResourceHandle;
import com.sap.netweaver.bc.rf.common.exception.OperationNotCompletedException;
import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;
import com.sapportals.wcm.repository.wrapping.RidListTransformer;
import com.sapportals.wcm.repository.wrapping.RidSetTransformer;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.exception.IncompleteOperationTransformer;
import com.sapportals.wcm.repository.wrapping.security.PermissionListTransformer;
import com.sapportals.wcm.repository.wrapping.security.PermissionTransformer;
import com.sapportals.wcm.util.uri.IRidList;
import com.sapportals.wcm.util.uri.IRidSet;
import java.util.*;

/**
 * Adapter for security manager
 */
public class SecurityAdapter implements ISecurityManager {

  protected com.sap.netweaver.bc.rf.mi.security.ISecurityManager sm;


  protected SecurityAdapter(com.sap.netweaver.bc.rf.mi.security.ISecurityManager sm) {
    if (sm == null) {
      throw new NullPointerException("sm is null");
    }
    this.sm = sm;
  }


  public IPermissionList getSupportedPermissions(IResource resource)
    throws ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return PermissionListTransformer.transform(this.sm.getSupportedPermissions(handle));
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IPermission getPermission(String name) {
    List all = null;
    try {
      // Note: Sec. managers must be changed to support null as parameter !
      all = this.sm.getSupportedPermissions(null);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      //TODO Exception handling ?
      throw new RuntimeException(ex.getMessage());
    }
    for (int i = 0; i < all.size(); i++) {
      com.sap.netweaver.bc.rf.common.security.IPermission p =
        (com.sap.netweaver.bc.rf.common.security.IPermission)all.get(i);
      if (p.getLocalName().equals(name)) {
        return PermissionTransformer.transform(p);
      }
    }
    //TODO contract ?
    return null;
  }


  public boolean isAllowed(IResource resource, IUser user, IPermission permission)
    throws ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return this.sm.isAllowed(handle, user.getUMEUser(), PermissionTransformer.transform(permission));
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public boolean isAllowed(IResource resource, IUser user, IPermissionList permissions)
    throws ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return this.sm.isAllowed(handle, user.getUMEUser(), PermissionListTransformer.transform(permissions));
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IRidSet isAllowed(IRidList ridList, IUser user, IPermissionList permissions, IResourceContext context)
    throws ResourceException {
    Set s = null;
    try {
      s = this.sm.isAllowed(RidListTransformer.transform(ridList),
        user.getUMEUser(), PermissionListTransformer.transform(permissions));
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
    catch (OperationNotCompletedException ex) {
      throw IncompleteOperationTransformer.transform(ex);
    }
    return RidSetTransformer.transform(s);
  }


  public String getType() {
    if (this.sm instanceof com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager) {
      // TODO: ???
      return "ACL";
    }
    else {
      return "?";
    }
  }

  private IResourceHandle getHandle(IResource res) {
    if (res instanceof ResourceImpl2) {
      return ((ResourceImpl2)res).getHandle();
    }
    else {
      return ((CollectionImpl2)res).getHandle();
    }
  }
}
