/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;
import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.manager.IResourceEventBroker;
import com.sapportals.wcm.util.events.*;

/**
 * TBD: Description of the class.
 */
public class ResourceEventBrokerAdapter implements IResourceEventBroker {

  private final com.sapportals.wcm.repository.manager.IResourceEventBroker newBroker;

  public ResourceEventBrokerAdapter(com.sapportals.wcm.repository.manager.IResourceEventBroker newBroker) {
    this.newBroker = newBroker;
  }

  public boolean send(IFrameworkTransaction ft, IEvent event, IEventSender sender)
    throws WcmException {
    return this.newBroker.send(ft, event, sender);
  }
  
  public void send(IEvent event, IEventSender sender)
    throws WcmException {
    this.newBroker.send(event, sender);
  }

  public void register(IEventSender sender)
    throws WcmException {
    this.newBroker.register(sender);
  }

  public void register(IEventReceiver receiver, IEvent template)
    throws WcmException {
    this.newBroker.register(receiver, template);
  }

  public void register(IEventReceiver receiver, IEvent template, IEventMapper mapping)
    throws WcmException {
    this.newBroker.register(receiver, template, mapping);
  }

  public void register(IEventReceiver receiver, IEvent template, int priority, boolean async)
    throws WcmException {
    this.newBroker.register(receiver, template, priority, async);
  }

  public void register(IEventReceiver receiver, IEvent template, IEventMapper mapping, int priority, boolean async)
    throws WcmException {
    this.newBroker.register(receiver, template, mapping, priority, async);
  }

  public void unregister(IEventSender sender)
    throws WcmException {
    this.newBroker.unregister(sender);
  }

  public void unregister(IEventReceiver receiver, IEvent template)
    throws WcmException {
    this.newBroker.unregister(receiver, template);
  }

  public void suspend(IEventReceiver receiver) {
    this.newBroker.suspend(receiver);
  }

  public void resume(IEventReceiver receiver) {
    this.newBroker.resume(receiver);
  }

  public void hold(IEventReceiver receiver, boolean collect) {
    this.newBroker.hold(receiver, collect);
  }

  public SenderMode getMode(IEventReceiver receiver) {
    return this.newBroker.getMode(receiver);
  }

  public IEventList getHoldEvents(IEventReceiver receiver) {
    return this.newBroker.getHoldEvents(receiver);
  }

  public IEventList clearHoldEvents(IEventReceiver receiver) {
    return this.newBroker.clearHoldEvents(receiver);
  }

  public IEventList getEvents() {
    return this.newBroker.getEvents();
  }

  public IEventList getEvents(IResource resource) {
    return this.newBroker.getEvents(resource);
  }
  
  public boolean mustSendResourceEventType(int type) {
    return this.newBroker.mustSendResourceEventType(type);
  }
  
}
