/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;
import com.sap.netweaver.bc.rf.common.IResourceHandle;
import com.sapportals.portal.security.usermanagement.IGroup;
import com.sapportals.portal.security.usermanagement.IRole;
import com.sapportals.portal.security.usermanagement.IUMPrincipal;
import com.sapportals.portal.security.usermanagement.IUser;
import com.sapportals.wcm.repository.CollectionImpl2;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.IResourceList;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.repository.ResourceImpl2;
import com.sapportals.wcm.repository.security.*;
import com.sapportals.wcm.repository.wrapping.exception.AclExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.security.*;
import com.sapportals.wcm.repository.wrapping.security.acl.*;
import com.sapportals.wcm.util.acl.*;
import java.util.*;

/**
 * Adapter for new AclSecurityManager
 */
public class ResourceAclAdapter implements IResourceAclManager {

  private com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager sm;

  protected ResourceAclAdapter(com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager sm) {
    if (sm == null) {
      throw new NullPointerException("sm is null");
    }
    this.sm = sm;
  }

  public IResourceAclEntry createAclEntry(IUMPrincipal principal, boolean negative, IAclPermission permission, int sortIndex)
    throws AclPersistenceException, UnsupportedOperationException, InvalidClassException {
    com.sap.security.api.IPrincipal newPrincipal = PrincipalTransformer.transform(principal);
    try {
      return AclEntryTransformer.transform(
        this.sm.createAclEntry(newPrincipal, AclPermissionTransformer.transform(permission), negative, false, sortIndex));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
  }

  public boolean areNegativeAclEntriesSupported() {
    return this.sm.supportsNegativeAclEntries();
  }


  public IResourceAcl createAcl(IResource resource)
    throws AclPersistenceException, NotAuthorizedException, AclExistsException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return AclTransformer.transform(this.sm.createAcl(handle), resource);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw (NotAuthorizedException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclExistsException ex) {
      throw (AclExistsException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public boolean assignForeignAcl(IResourceAcl foreignAcl, IResource resource)
    throws AclPersistenceException, NotAuthorizedException, AclExistsException, ResourceException {
    throw new java.lang.UnsupportedOperationException();
  }


  public IResourceAcl getAcl(IResource resource)
    throws AclPersistenceException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return AclTransformer.transform(this.sm.getAcl(handle), resource);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IResourceAcl getInheritedAcl(IResource resource)
    throws AclPersistenceException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return AclTransformer.transform(this.sm.getInheritedAcl(handle), resource);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public boolean removeAcl(IResource resource)
    throws AclPersistenceException, NotAuthorizedException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      this.sm.removeAcl(handle);
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclNotAuthorizedException ex) {
      throw (NotAuthorizedException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public boolean removeAcl(IResourceAcl acl)
    throws AclPersistenceException, NotAuthorizedException, InvalidClassException, ResourceException {
    try {
      this.sm.removeAcl(AclTransformer.transform(acl));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IObjectTypeList getSupportedObjectTypes()
    throws AclPersistenceException {
    try {
      return ObjectTypeTransformer.transformList(this.sm.getSupportedObjectTypes());
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
  }


  public IObjectType getObjectType(IResource resource)
    throws AclPersistenceException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return ObjectTypeTransformer.transform(this.sm.getObjectType(handle));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IAclPermissionList getSupportedPermissions(IResource resource)
    throws AclPersistenceException, ResourceException {
    IResourceHandle handle = this.getHandle(resource);
    try {
      return AclPermissionListTransformer.transform(this.sm.getSupportedPermissions(handle));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }


  public IAclPermission getPermission(String name)
    throws AclPersistenceException {
    try {
      return AclPermissionTransformer.transform(this.sm.getPermission(name));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
  }


  public boolean addSupportedPermission(IObjectType objectType, IAclPermission permission)
    throws AclPersistenceException, PredefinedPermissionException {
    try {
      this.sm.addSupportedPermission(ObjectTypeTransformer.transform(objectType),
        AclPermissionTransformer.transform(permission));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPredefinedPermissionException ex) {
      throw (PredefinedPermissionException)AclExceptionTransformer.transform(ex);
    }
  }


  public boolean removeSupportedPermission(IObjectType objectType, IAclPermission permission)
    throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
    try {
      this.sm.removeSupportedPermission(ObjectTypeTransformer.transform(objectType),
        AclPermissionTransformer.transform(permission));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPredefinedPermissionException ex) {
      throw (PredefinedPermissionException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPermissionUsedException ex) {
      throw (PermissionUsedException)AclExceptionTransformer.transform(ex);
    }
  }


  public IAclPermission createPermission(String name)
    throws AclPersistenceException, PermissionExistsException {
    try {
      return AclPermissionTransformer.transform(this.sm.createPermission(name));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPermissionExistsException ex) {
      throw (PermissionExistsException)AclExceptionTransformer.transform(ex);
    }
  }

  public boolean removePermission(IAclPermission permission)
    throws AclPersistenceException, PredefinedPermissionException, PermissionUsedException {
    try {
      this.sm.removePermission(AclPermissionTransformer.transform(permission));
      return false;
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPredefinedPermissionException ex) {
      throw (PredefinedPermissionException)AclExceptionTransformer.transform(ex);
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPermissionUsedException ex) {
      throw (PermissionUsedException)AclExceptionTransformer.transform(ex);
    }
  }


  public boolean isPermissionUsedInAcl(IAclPermission permission)
    throws AclPersistenceException {
    try {
      return this.sm.isPermissionUsedInAcl(AclPermissionTransformer.transform(permission));
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
  }


  public boolean isReadOnly()
    throws AclPersistenceException {
    try {
      return this.sm.isReadOnly();
    }
    catch (com.sap.netweaver.bc.rf.common.security.acl.AclPersistenceException ex) {
      throw (AclPersistenceException)AclExceptionTransformer.transform(ex);
    }
  }


  public boolean[] areAclsUpToDate(IResourceAcl[] acls)
    throws AclPersistenceException {
    throw new UnsupportedOperationException();
  }


  public IResourceList propagateAcl_Remove(IResource resource)
    throws AclPersistenceException, ResourceException, NoAclException, InvalidClassException, NotAuthorizedException {
    throw new UnsupportedOperationException();
  }


  public long getDBVersion() {
    throw new UnsupportedOperationException();
  }

  private IResourceHandle getHandle(IResource res) {
    if (res instanceof ResourceImpl2) {
      return ((ResourceImpl2)res).getHandle();
    }
    else {
      return ((CollectionImpl2)res).getHandle();
    }
  }
}
