/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;
import com.sap.netweaver.bc.rf.mi.*;

import com.sapportals.wcm.crt.configuration.*;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;
import com.sapportals.wcm.repository.service.*;
import com.sapportals.wcm.repository.wrapping.*;
import com.sapportals.wcm.repository.wrapping.support.SupportedOptionTransformer;

import java.util.*;

/**
 * Provides the familiar IRepositoryManager interface for new managers.
 */
public class ManagerAdapter implements IRepositoryManager {

  private AbstractManager newManager;
  private Properties properties;


  public ManagerAdapter(AbstractManager newManager) {
    this.newManager = newManager;
  }


  public ISecurityManager getSecurityManager(IResource resource)
    throws ResourceException {
    com.sap.netweaver.bc.rf.mi.security.ISecurityManager sm = this.newManager.getSecurityManager();
    if (sm == null) {
      return null;
    }
    if (sm instanceof com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager) {
      return new AclSecurityAdapter((com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager)sm);
    }
    else {
      return new SecurityAdapter(sm);
    }
  }


  public IPropertySearchManager getPropertySearchManager(IResource resource)
    throws ResourceException {
    return null;
  }


  public String getPrefix() {
    return this.newManager.getRidPrefix();
  }


  public Properties getConfig() {
    if (this.properties == null) {
      this.properties = this.convertConfigToProperties(this.getConfiguration());
    }
    return (Properties)this.properties.clone();
  }


  public IConfiguration getConfiguration() {
    return this.newManager.getConfig();
  }


  public String getID() {
    return this.newManager.getId();
  }


  public String getDescription() {
    return (String)this.getConfiguration().getAttribute(ICmRuntimeConst.CONFIG_ATTRIBUTE_NAME.DESCRIPTION, null);
  }


  public IResourceEventBroker getEventBroker() {
    return new ResourceEventBrokerAdapter(this.newManager.getEventBroker());
  }


  public final Collection getAllServices()
    throws ResourceException {
    return ResourceFactory.getInstance().getServiceFactory().getAllRepositoryServices(this);
  }


  public final IRepositoryService getService(String type)
    throws ResourceException {
    return ResourceFactory.getInstance().getServiceFactory().getRepositoryService(this, type);
  }


  public final boolean isServiceAvailable(String type)
    throws ResourceException {
    return ResourceFactory.getInstance().getServiceFactory().isRepositoryServiceAvailable(this, type);
  }


  public ISupportedOptionSet getSupportedOptions(IResource resource) {
    if (resource == null) {
      return new SupportedOptionSet(
        SupportedOptionTransformer.transform(
        this.newManager.getSupportedOptions(null)));
    }
    else {
      return new SupportedOptionSet(
        SupportedOptionTransformer.transform(
        this.newManager.getSupportedOptions(((ResourceImpl)resource).getHandle())));
    }
  }


  public com.sapportals.wcm.repository.NameInfo getNameInfo() {
    return NameInfoTransformer.transform(this.newManager.getNameInfo());
  }


  /**
   * Helper method for conversion of configuration data into properties.
   *
   * @param config TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  private final Properties convertConfigToProperties(IConfiguration config) {
    Properties props = new Properties();
    String[] attributeNames = config.getAttributeNames();
    for (int i = 0; i < attributeNames.length; i++) {
      String name = attributeNames[i];
      String value = config.getAttribute(name, null);
      if (value != null) {
        props.setProperty(name, value);
      }
    }
    return props;
  }
}
