/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;

import com.sap.tc.logging.Location;
import com.sapportals.config.fwk.IConfigurable;
import com.sapportals.config.fwk.IConfigurableChecker;

import com.sapportals.config.fwk.InvalidCheckConfigException;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.repository.ResourceFactory;
import com.sapportals.wcm.repository.manager.IRepositoryManager;

import java.util.Iterator;
/**
 * CM repository manager. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Id: CmConfigChecker.java,v 1.3 2003/07/10 11:41:51 mbo Exp $
 */
public class ConfigChecker implements IConfigurableChecker {

  private static Location LOC = Location.getLocation(ConfigChecker.class);

  public void check(IConfigurable newconfig) throws InvalidCheckConfigException {
    if (LOC.beDebug()) {
      LOC.debugT("entering repository prefix check!");
    }
    // Check if properties have changed which are not allowed at runtime
    String id = newconfig.getIdValue();
    String prefix = newconfig.getPropertyValue("prefix");


    try {
      Iterator iterator = ResourceFactory.getInstance().getManagerFactory().getAllRepositoryManagers().iterator();
      while (iterator.hasNext()) {
        IRepositoryManager manager = (IRepositoryManager)iterator.next();
        if (!id.equals(manager.getID()) && prefix.equals(manager.getPrefix())) {
          throw new InvalidCheckConfigException("The prefix " + prefix + " of repository " + id + " is already in " + "use for repository " + manager.getID());
        }
      }

      if (LOC.beDebug()) {
        LOC.debugT("repository '" + id + "' seems to be ok.");
      }
    } catch (ResourceException ignored) {
      if (LOC.beDebug()) {
        LOC.debugT("repository '" + id + "' seems to be ok.");
      }
    }

  }

}
