/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.crt.component.ComponentState;
import com.sapportals.wcm.crt.component.ComponentStateHandler;
import com.sapportals.wcm.crt.component.IComponent;
import com.sapportals.wcm.crt.component.IComponentInfo;
import com.sapportals.wcm.crt.component.ILifecycleInfo;
import com.sapportals.wcm.crt.component.IThreadSafe;
import com.sapportals.wcm.crt.component.StartupException;
import com.sapportals.wcm.crt.configuration.ConfigurationException;

/**
 * A comonent that provides some system information, e.g. database patch level.
 * The information is initialized when the respective static methods are called
 * by CmSystem.
 * <p>
 * 
 * Copyright (c) SAP AG 2002
 * 
 * @version $Id:$
 */
public class CmSystemInfo implements IComponent, IThreadSafe, IComponentInfo,
		ILifecycleInfo {

	// Log with CmSystem category !
	private static Location TRACE = Location
			.getLocation(com.sapportals.wcm.repository.runtime.CmSystemInfo.class);

	private final ComponentStateHandler stateHandler = new ComponentStateHandler(
			this);

	public String getName() {
		return "SystemInfo";
	}

	public String getDescription(Locale locale) {
		return "Provides information about the CM system setup";
	}

	public Properties getProperties() {
		Properties properties = new Properties();
		try {
			List startupHistory = CmSystem.getInstance().getStartupHistory();
			for(int i=0; i<startupHistory.size(); i++) {
				properties.put(i + ". startup", startupHistory.get(i).toString() );
      }
		} catch (CmStartupException x) {
			;
		}
		return properties;
	}

	//---------------------------------------------------------------------------
	// ILifecycleInfo
	//---------------------------------------------------------------------------

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getCreationDate()
	 */
	public Date getCreationDate() {
		return this.stateHandler.getCreationDate();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getLastConfigurationException()
	 */
	public ConfigurationException getLastConfigurationException() {
		return this.stateHandler.getLastConfigurationException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getLastReconfigurationDate()
	 */
	public Date getLastReconfigurationDate() {
		return this.stateHandler.getLastReconfigurationDate();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getNextAutoRestartDate()
	 */
	public Date getNextAutoRestartDate() {
		return this.stateHandler.getNextAutoRestartDate();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getStartupException()
	 */
	public StartupException getStartupException() {
		return this.stateHandler.getStartupException();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.sapportals.wcm.crt.component.ILifecycleInfo#getState()
	 */
	public ComponentState getState() {
		return this.stateHandler.getState();
	}

}