/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;
import com.sapportals.config.fwk.IConfigUri;

import com.sapportals.wcm.crt.configuration.ConfigurationException;
import java.util.*;

/**
 * A read-only object for the system properties of a repository service.
 */
public final class CmRepServiceProperties {
  private String type;
  private String[] childConfigClassNames;
  private IConfigUri configUri;

  public CmRepServiceProperties(String type, IConfigUri configUri, String[] childConfigClassNames) {
    if (type == null) {
      throw new IllegalArgumentException("type is null");
    }
    if (configUri == null) {
      throw new IllegalArgumentException("configUri is null");
    }
    if (childConfigClassNames == null) {
      throw new IllegalArgumentException("childConfigClassNames is null");
    }
    this.type = type;
    this.configUri = configUri;
    this.childConfigClassNames = childConfigClassNames;
  }

  public String getType() {
    return this.type;
  }

  public IConfigUri getConfigUri() {
    return this.configUri;
  }

  public String[] getChildConfigClassNames() {
    return this.childConfigClassNames;
  }
}
