/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;

import com.sapportals.config.fwk.IConfigUri;
import com.sapportals.wcm.crt.configuration.ConfigurationException;
import java.util.*;

/**
 * A read-only object for the system properties of a repository manager.
 */
public final class CmManagerProperties {
  private String prefix;
  private String[] childConfigClassNames;  
  private List listServiceIDs;
  private IConfigUri configUri;
  
  public CmManagerProperties(String prefix, IConfigUri configUri, ArrayList serviceIDs, String[] childConfigClassNames) {
    this.prefix = prefix;
    this.childConfigClassNames = childConfigClassNames;
    this.listServiceIDs = serviceIDs;
    this.configUri = configUri;
  }

  public String getPrefix() {
    return this.prefix;
  }

  public List getServiceIDs() {
    return Collections.unmodifiableList(this.listServiceIDs);
  }
  
  public IConfigUri getConfigUri() {
    return this.configUri;
  }
  public String[] getChildConfigClassNames() {
    return this.childConfigClassNames;
  }
}
