/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.runtime;
import com.sapportals.portal.security.usermanagement.IUMPrincipal;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.IResourceList;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.repository.manager.*;
import com.sapportals.wcm.repository.security.*;
import com.sapportals.wcm.util.acl.*;

/**
 * Adapter for new AclSecurityManager
 */
public class AclSecurityAdapter extends SecurityAdapter
   implements IAclSecurityManager {

  protected AclSecurityAdapter(com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager sm) {
    super(sm);
  }

  public IResourceAclManager getAclManager() {
    return new ResourceAclAdapter((com.sap.netweaver.bc.rf.mi.security.acl.IAclSecurityManager)this.sm);
  }

}
