/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: RepFilterContainer.java,v 1.1 2004/05/12 13:10:12 sei Exp $
 */
package com.sapportals.wcm.repository.manager;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

import com.sapportals.wcm.crt.CrtSystem;
import com.sapportals.wcm.crt.component.ComponentException;
import com.sapportals.wcm.crt.component.ComponentState;
import com.sapportals.wcm.crt.component.ContextException;
import com.sapportals.wcm.crt.component.IComponent;
import com.sapportals.wcm.crt.component.IComponentInfo;
import com.sapportals.wcm.crt.component.IComponentManager;
import com.sapportals.wcm.crt.component.IContainer;
import com.sapportals.wcm.crt.component.IContext;
import com.sapportals.wcm.crt.component.ILifecycleInfo;
import com.sapportals.wcm.crt.component.IThreadSafe;
import com.sapportals.wcm.crt.component.StartupException;
import com.sapportals.wcm.crt.configuration.ConfigurationException;
import com.sapportals.wcm.repository.runtime.CmConfigurationProvider;
import com.sapportals.wcm.repository.runtime.CmFilterProperties;
import com.sapportals.wcm.repository.runtime.CmRegistry;

/**
 * Aggregates all filters for a specific repository.<p>
 *
 * Copyright (c) SAP AG 2001 - 2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: RepFilterContainer.java,v 1.1 2004/05/12 13:10:12 sei Exp $
 */
public class RepFilterContainer implements IContainer, IThreadSafe,
  IComponentInfo, ILifecycleInfo {
    
  private IComponentManager containerManager;
  private ConfigurationException dummyException;

  public RepFilterContainer() {
  }

  public IComponentManager getComponentManager() {
    return this.containerManager;
  }

  public final void contextualize(IContext context) throws ContextException {
    String id = (String)context.getParameters();
    this.containerManager = new MyComponentManager(id); 
  }

  // ---------------------------------------------------------------------------
  // interface IComponentInfo
  // ---------------------------------------------------------------------------

  public String getName() {
    return "Filters";
  }

  public String getDescription(Locale locale) {
    // TODO
    return "all filter active for this repository";
  }

  public Properties getProperties() {
    return null;
  }

  // ---------------------------------------------------------------------------
  // interface ILifecycleInfo
  // ---------------------------------------------------------------------------

  public ComponentState getState() {
    // Combine state of all child components:
    // If not all components are running and config is OK create a fake state and exception so
    // that the CRT repository will return a WARN or ERROR mimetype (yellow or red bullet!).
    String[] childKeys = this.getComponentManager().listComponentKeys();
    int countNotRunning = 0;
    int countConfigException = 0;
    IComponent comp = null;
    for (int i = 0; i < childKeys.length; i++) {
      try {
        comp = this.getComponentManager().lookupComponent(childKeys[i]);
        ComponentState state = ((ILifecycleInfo)comp).getState();
        if (state != null && !state.equals(ComponentState.RUNNING)) {
          countNotRunning++;
        }
        if (((ILifecycleInfo)comp).getLastConfigurationException() != null) {
          countConfigException++;
        }
      }
      catch (ComponentException ignored) {
      }
      catch (Exception ignored) {
      }
      finally {
        if (comp != null) {
          this.getComponentManager().releaseComponent(comp);
        }
      }
    }
    this.dummyException = null;
    this.dummyException = null;
    if (countNotRunning > 0) {
      if (countNotRunning == childKeys.length) {
        return ComponentState.STOPPED;
      }
      else if (countConfigException > 0) {
        this.dummyException = new ConfigurationException("");
      }
    }
    return ComponentState.RUNNING;
  }

  public ConfigurationException getLastConfigurationException() {
    return this.dummyException;
  }

  public StartupException getStartupException() {
    return null;
  }

  public Date getCreationDate() {
    return null;
  }

  public Date getLastReconfigurationDate() {
    return null;
  }

  public Date getNextAutoRestartDate() {
    return null;
  }
  
  private static class MyComponentManager implements IComponentManager {
    
    private static final int[] FTypes = new int[] {
      CmFilterProperties.TYPE.CONTENT,
      CmFilterProperties.TYPE.NAMESPACE,
      CmFilterProperties.TYPE.PROPERTY,
      CmFilterProperties.TYPE.URI,
    };
    
    private static final String[] S_EMPTY = new String[0];
    
    private final String id;
    public MyComponentManager(String repID) {
      this.id = repID;
    }
    
		public boolean hasComponent(String key) {
      return keys().contains(key);
		}

		public String[] listComponentKeys() {
			return (String[])keys().toArray(S_EMPTY);
		}

		public IComponent lookupComponent(String key) throws ComponentException {
      if (hasComponent(key)) {
        IComponent comp = CrtSystem.getInstance().lookupComponentByUri(CmConfigurationProvider.CONTAINER_URIS.FILTER);
        if (comp instanceof IContainer) {
          IContainer container = (IContainer)comp;
          return container.getComponentManager().lookupComponent(key);
        }
      }
      return null;
		}

		public void releaseComponent(IComponent component) {
		}

    private Set keys() {
      Set keys = new HashSet();
      for (int i = 0; i < FTypes.length; ++i) {
        List filters = CmRegistry.registry.getFilterList(this.id, FTypes[i]);
        for (int j = 0, m = filters.size(); j < m; ++j) {
          keys.add(filters.get(j));
        }
      }
      return keys;
    }
  }
}