/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import java.util.*;

/**
 * TBD: Description of the class.
 */
public final class PermissionList implements IPermissionList {

  private final List list;

  public PermissionList() {
    this.list = new ArrayList(20);
  }

  public void add(IPermission permission) {
    this.list.add(permission);
  }

  public IPermissionListIterator iterator() {
    return new PermissionListIterator(this.list.iterator());
  }

  public int size() {
    return this.list.size();
  }

  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj instanceof PermissionList) {
      return this.list.equals(((PermissionList)obj).list);
    }
    return false;
  }

  public int hashCode() {
    return this.list.hashCode();
  }
}
