/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.manager.*;
import java.util.*;

/**
 * Copyright (c) SAP AG 2002
 *
 * @author Dirk Sabiwalsky
 * @version $Id: Permission.java,v 1.3 2002/08/30 10:36:53 sei Exp $
 */
public final class Permission implements IPermission {

  public final static IPermission LIST = new Permission(IPermission.PERMISSION_LIST);
  public final static IPermission CREATE = new Permission(IPermission.PERMISSION_CREATE);
  public final static IPermission READ_NODE_PROPERTIES = new Permission(IPermission.PERMISSION_READ_NODE_PROPERTIES);
  public final static IPermission WRITE_NODE_PROPERTIES = new Permission(IPermission.PERMISSION_WRITE_NODE_PROPERTIES);
  public final static IPermission DELETE_NODE = new Permission(IPermission.PERMISSION_DELETE_NODE);

  public final static IPermission READ_CONTENT = new Permission(IPermission.PERMISSION_READ_CONTENT);
  public final static IPermission READ_PROPERTIES = new Permission(IPermission.PERMISSION_READ_PROPERTIES);
  public final static IPermission WRITE_CONTENT = new Permission(IPermission.PERMISSION_WRITE_CONTENT);
  public final static IPermission WRITE_PROPERTIES = new Permission(IPermission.PERMISSION_WRITE_PROPERTIES);
  public final static IPermission DELETE = new Permission(IPermission.PERMISSION_DELETE);

  public final static Map BY_NAME;

  static {
    Map map = new HashMap(17);
    map.put(LIST.getName(), LIST);
    map.put(CREATE.getName(), CREATE);
    map.put(READ_NODE_PROPERTIES.getName(), READ_NODE_PROPERTIES);
    map.put(WRITE_NODE_PROPERTIES.getName(), WRITE_NODE_PROPERTIES);
    map.put(DELETE_NODE.getName(), DELETE_NODE);
    map.put(READ_CONTENT.getName(), READ_CONTENT);
    map.put(READ_PROPERTIES.getName(), READ_PROPERTIES);
    map.put(WRITE_CONTENT.getName(), WRITE_CONTENT);
    map.put(WRITE_PROPERTIES.getName(), WRITE_PROPERTIES);
    map.put(DELETE.getName(), DELETE);
    BY_NAME = Collections.unmodifiableMap(map);
  }

  private final String name;
  private final String description;

  public Permission(String name) {
    if (name == null) {
      throw new NullPointerException();
    }
    this.name = name;
    String descr = this.name;
    try {
      descr = ResourceBundle.getBundle(IPermission.class.getName()).getString(this.name);
    }
    catch (Exception e) {
      com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(e.getMessage());
    }
    this.description = descr;
  }

  public String getName() {
    return this.name;
  }

  public final String getDescription() {
    return this.description;
  }

  public final String getDescription(Locale locale) {
    try {
      return ResourceBundle.getBundle(IPermission.class.getName(), locale).getString(this.name);
    }
    catch (Exception e) {
      return this.description;
    }
  }

  public boolean equals(IPermission permission) {
    return this.name.equals(permission.getName());
  }

  public boolean equals(Object other) {
    if (other instanceof Permission) {
      return this.name.equals(((Permission)other).name);
    }
    return false;
  }

  public int hashCode() {
    return this.name.hashCode();
  }

  public String toString() {
    return "Permission[+" + this.name + "]";
  }
}
